/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-kafka-client-js/kafka_header */
var utils = require('vertx-js/util/utils');
var Buffer = require('vertx-js/buffer');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JKafkaHeader = Java.type('io.vertx.kafka.client.producer.KafkaHeader');

/**
 Vert.x Kafka producer record header.

 @class
*/
var KafkaHeader = function(j_val) {

  var j_kafkaHeader = j_val;
  var that = this;

  var __super_header = this.header;
  var __super_header = this.header;
  var __super_key = this.key;
  var __super_value = this.value;
  /**

   @public

   @return {string} the buffer key
   */
  this.key =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedkey == null) {
        that.cachedkey = j_kafkaHeader["key()"]();
      }
      return that.cachedkey;
    } else if (typeof __super_key != 'undefined') {
      return __super_key.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Buffer} the buffer value
   */
  this.value =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedvalue == null) {
        that.cachedvalue = utils.convReturnVertxGen(Buffer, j_kafkaHeader["value()"]());
      }
      return that.cachedvalue;
    } else if (typeof __super_value != 'undefined') {
      return __super_value.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_kafkaHeader;
};

KafkaHeader._jclass = utils.getJavaClass("io.vertx.kafka.client.producer.KafkaHeader");
KafkaHeader._jtype = {accept: function(obj) {
    return KafkaHeader._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(KafkaHeader.prototype, {});
    KafkaHeader.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
KafkaHeader._create = function(jdel) {var obj = Object.create(KafkaHeader.prototype, {});
  KafkaHeader.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-kafka-client-js/kafka_header
 @param key {string} 
 @param value {string} 
 @return {KafkaHeader}
 */
KafkaHeader.header =  function() {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel) {
    return utils.convReturnVertxGen(KafkaHeader, JKafkaHeader["header(java.lang.String,io.vertx.core.buffer.Buffer)"](__args[0], __args[1]._jdel)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
    return utils.convReturnVertxGen(KafkaHeader, JKafkaHeader["header(java.lang.String,java.lang.String)"](__args[0], __args[1])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = KafkaHeader;