/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/open_api3_router_factory */
var utils = require('vertx-js/util/utils');
var RouterFactory = require('vertx-web-api-contract-js/router_factory');
var Vertx = require('vertx-js/vertx');
var Router = require('vertx-web-js/router');
var RoutingContext = require('vertx-web-js/routing_context');
var BodyHandler = require('vertx-web-js/body_handler');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JOpenAPI3RouterFactory = Java.type('io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory');
var RouterFactoryOptions = Java.type('io.vertx.ext.web.api.contract.RouterFactoryOptions');

/**
 Interface for OpenAPI3RouterFactory. <br/>
 @class
*/
var OpenAPI3RouterFactory = function(j_val) {

  var j_openAPI3RouterFactory = j_val;
  var that = this;
  RouterFactory.call(this, j_val);

  var __super_addSecurityHandler = this.addSecurityHandler;
  var __super_setOptions = this.setOptions;
  var __super_getOptions = this.getOptions;
  var __super_getRouter = this.getRouter;
  var __super_getValidationFailureHandler = this.getValidationFailureHandler;
  var __super_setValidationFailureHandler = this.setValidationFailureHandler;
  var __super_setNotImplementedFailureHandler = this.setNotImplementedFailureHandler;
  var __super_setBodyHandler = this.setBodyHandler;
  var __super_addGlobalHandler = this.addGlobalHandler;
  var __super_setExtraOperationContextPayloadMapper = this.setExtraOperationContextPayloadMapper;
  var __super_addSecuritySchemaScopeValidator = this.addSecuritySchemaScopeValidator;
  var __super_addHandlerByOperationId = this.addHandlerByOperationId;
  var __super_addFailureHandlerByOperationId = this.addFailureHandlerByOperationId;
  var __super_mountOperationToEventBus = this.mountOperationToEventBus;
  var __super_mountServiceFromTag = this.mountServiceFromTag;
  var __super_mountServicesFromExtensions = this.mountServicesFromExtensions;
  var __super_create = this.create;
  var __super_create = this.create;
  /**
   Mount to paths that have to follow a security schema a security handler

   @public
   @param securitySchemaName {string} 
   @param handler {function} 
   @return {RouterFactory} 
   */
  this.addSecurityHandler =  function(securitySchemaName, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_openAPI3RouterFactory["addSecurityHandler(java.lang.String,io.vertx.core.Handler)"](securitySchemaName, function(jVal) {
        handler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_addSecurityHandler != 'undefined') {
      return __super_addSecurityHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set options of router factory. For more info 

   @public
   @param options {Object} 
   @return {RouterFactory} 
   */
  this.setOptions =  function(options) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_openAPI3RouterFactory["setOptions(io.vertx.ext.web.api.contract.RouterFactoryOptions)"](options  != null ? new RouterFactoryOptions(new JsonObject(Java.asJSONCompatible(options))) : null) ;
      return that;
    } else if (typeof __super_setOptions != 'undefined') {
      return __super_setOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get options of router factory. For more info 

   @public

   @return {Object} 
   */
  this.getOptions =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnDataObjectAnnotated(j_openAPI3RouterFactory["getOptions()"]()) ;
    } else if (typeof __super_getOptions != 'undefined') {
      return __super_getOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
   without assigned handlers<br/>
   <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.

   @public

   @return {Router} 
   */
  this.getRouter =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Router, j_openAPI3RouterFactory["getRouter()"]()) ;
    } else if (typeof __super_getRouter != 'undefined') {
      return __super_getRouter.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {function}
   */
  this.getValidationFailureHandler =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnHandler(j_openAPI3RouterFactory["getValidationFailureHandler()"](), function(result) { return result._jdel; }) ;
    } else if (typeof __super_getValidationFailureHandler != 'undefined') {
      return __super_getValidationFailureHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set default validation failure handler. You can enable/disable this feature from
   

   @public
   @param validationFailureHandler {function} 
   @return {RouterFactory} this object
   */
  this.setValidationFailureHandler =  function(validationFailureHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_openAPI3RouterFactory["setValidationFailureHandler(io.vertx.core.Handler)"](function(jVal) {
        validationFailureHandler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_setValidationFailureHandler != 'undefined') {
      return __super_setValidationFailureHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set not implemented failure handler. It's called when you don't define an handler for a
   specific operation. You can enable/disable this feature from
   

   @public
   @param notImplementedFailureHandler {function} 
   @return {RouterFactory} this object
   */
  this.setNotImplementedFailureHandler =  function(notImplementedFailureHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_openAPI3RouterFactory["setNotImplementedFailureHandler(io.vertx.core.Handler)"](function(jVal) {
        notImplementedFailureHandler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_setNotImplementedFailureHandler != 'undefined') {
      return __super_setNotImplementedFailureHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Supply your own BodyHandler if you would like to control body limit, uploads directory and deletion of uploaded files

   @public
   @param bodyHandler {BodyHandler} 
   @return {RouterFactory} self
   */
  this.setBodyHandler =  function(bodyHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_openAPI3RouterFactory["setBodyHandler(io.vertx.ext.web.handler.BodyHandler)"](bodyHandler._jdel) ;
      return that;
    } else if (typeof __super_setBodyHandler != 'undefined') {
      return __super_setBodyHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add global handler to be applied prior to {@link Router} being generated. <br/>
   Please note that you should not add a body handler inside that list. If you want to modify the body handler, please use 

   @public
   @param globalHandler {function} 
   @return {RouterFactory} this object
   */
  this.addGlobalHandler =  function(globalHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_openAPI3RouterFactory["addGlobalHandler(io.vertx.core.Handler)"](function(jVal) {
        globalHandler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_addGlobalHandler != 'undefined') {
      return __super_addGlobalHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   When set, this function is called while creating the payload of <a href="../../dataobjects.html#OperationRequest">OperationRequest</a>

   @public
   @param extraOperationContextPayloadMapper {function} 
   @return {RouterFactory} 
   */
  this.setExtraOperationContextPayloadMapper =  function(extraOperationContextPayloadMapper) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_openAPI3RouterFactory["setExtraOperationContextPayloadMapper(java.util.function.Function)"](function(jVal) {
        var jRet = extraOperationContextPayloadMapper(utils.convReturnVertxGen(RoutingContext, jVal));
        return utils.convParamJsonObject(jRet);
      }) ;
      return that;
    } else if (typeof __super_setExtraOperationContextPayloadMapper != 'undefined') {
      return __super_setExtraOperationContextPayloadMapper.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a particular scope validator. The main security schema will not be called if a specific scope validator is
   configured

   @public
   @param securitySchemaName {string} 
   @param scopeName {string} 
   @param handler {function} 
   @return {OpenAPI3RouterFactory} this factory
   */
  this.addSecuritySchemaScopeValidator =  function(securitySchemaName, scopeName, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_openAPI3RouterFactory["addSecuritySchemaScopeValidator(java.lang.String,java.lang.String,io.vertx.core.Handler)"](securitySchemaName, scopeName, function(jVal) {
        handler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_addSecuritySchemaScopeValidator != 'undefined') {
      return __super_addSecuritySchemaScopeValidator.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add an handler by operation_id field in Operation object

   @public
   @param operationId {string} 
   @param handler {function} 
   @return {OpenAPI3RouterFactory} this factory
   */
  this.addHandlerByOperationId =  function(operationId, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_openAPI3RouterFactory["addHandlerByOperationId(java.lang.String,io.vertx.core.Handler)"](operationId, function(jVal) {
        handler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_addHandlerByOperationId != 'undefined') {
      return __super_addHandlerByOperationId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a failure handler by operation_id field in Operation object

   @public
   @param operationId {string} 
   @param failureHandler {function} 
   @return {OpenAPI3RouterFactory} this factory
   */
  this.addFailureHandlerByOperationId =  function(operationId, failureHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_openAPI3RouterFactory["addFailureHandlerByOperationId(java.lang.String,io.vertx.core.Handler)"](operationId, function(jVal) {
        failureHandler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_addFailureHandlerByOperationId != 'undefined') {
      return __super_addFailureHandlerByOperationId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Specify to route an incoming request for specified operation id to a Web Api Service mounted at the specified address on event bus. Please give a look at <a href="https://vertx.io/docs/vertx-web-api-service/java/">vertx-web-api-service documentation</a> for more informations

   @public
   @param operationId {string} 
   @param address {string} 
   @return {OpenAPI3RouterFactory} this factory
   */
  this.mountOperationToEventBus =  function(operationId, address) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      j_openAPI3RouterFactory["mountOperationToEventBus(java.lang.String,java.lang.String)"](operationId, address) ;
      return that;
    } else if (typeof __super_mountOperationToEventBus != 'undefined') {
      return __super_mountOperationToEventBus.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Specify to route an incoming request for all operations that contains the specified tag to a Web Api Service mounted at the specified address on event bus.
   The request is handled by the method that matches the operation id. Please give a look at <a href="https://vertx.io/docs/vertx-web-api-service/java/">vertx-web-api-service documentation</a> for more informations

   @public
   @param tag {string} 
   @param address {string} 
   @return {OpenAPI3RouterFactory} this factory
   */
  this.mountServiceFromTag =  function(tag, address) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      j_openAPI3RouterFactory["mountServiceFromTag(java.lang.String,java.lang.String)"](tag, address) ;
      return that;
    } else if (typeof __super_mountServiceFromTag != 'undefined') {
      return __super_mountServiceFromTag.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Introspect the OpenAPI spec to mount handlers for all operations that specifies a x-vertx-event-bus annotation. Please give a look at <a href="https://vertx.io/docs/vertx-web-api-service/java/">vertx-web-api-service documentation</a> for more informations

   @public

   @return {OpenAPI3RouterFactory} this factory
   */
  this.mountServicesFromExtensions =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_openAPI3RouterFactory["mountServicesFromExtensions()"]() ;
      return that;
    } else if (typeof __super_mountServicesFromExtensions != 'undefined') {
      return __super_mountServicesFromExtensions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_openAPI3RouterFactory;
};

OpenAPI3RouterFactory._jclass = utils.getJavaClass("io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory");
OpenAPI3RouterFactory._jtype = {accept: function(obj) {
    return OpenAPI3RouterFactory._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(OpenAPI3RouterFactory.prototype, {});
    OpenAPI3RouterFactory.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
OpenAPI3RouterFactory._create = function(jdel) {var obj = Object.create(OpenAPI3RouterFactory.prototype, {});
  OpenAPI3RouterFactory.apply(obj, arguments);
  return obj;
}
/**
 Create a new OpenAPI3RouterFactory

 @memberof module:vertx-web-api-contract-js/open_api3_router_factory
 @param vertx {Vertx} 
 @param url {string} location of your spec. It can be an absolute path, a local path or remote url (with HTTP protocol) 
 @param auth {Array.<Object>} list of authorization values needed to access the remote url. Each item should be json representation of an  
 @param handler {function} When specification is loaded, this handler will be called with AsyncResult<OpenAPI3RouterFactory> 
 */
OpenAPI3RouterFactory.create =  function() {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
    JOpenAPI3RouterFactory["create(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](__args[0]._jdel, __args[1], function(ar) {
      if (ar.succeeded()) {
        __args[2](utils.convReturnVertxGen(OpenAPI3RouterFactory, ar.result()), null);
      } else {
        __args[2](null, ar.cause());
      }
    });
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string') {
    var __prom = Promise.promise();
    var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
    JOpenAPI3RouterFactory["create(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](__args[0]._jdel, __args[1], function(ar) {
      if (ar.succeeded()) {
        __prom_completer_handler(utils.convReturnVertxGen(OpenAPI3RouterFactory, ar.result()), null);
      } else {
        __prom_completer_handler(null, ar.cause());
      }
    });
    return __prom.future();
  } else if (__args.length === 4 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'object' && __args[2] instanceof Array && typeof __args[3] === 'function') {
    JOpenAPI3RouterFactory["create(io.vertx.core.Vertx,java.lang.String,java.util.List,io.vertx.core.Handler)"](__args[0]._jdel, __args[1], utils.convParamListJsonObject(__args[2]), function(ar) {
      if (ar.succeeded()) {
        __args[3](utils.convReturnVertxGen(OpenAPI3RouterFactory, ar.result()), null);
      } else {
        __args[3](null, ar.cause());
      }
    });
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'object' && __args[2] instanceof Array) {
    var __prom = Promise.promise();
    var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
    JOpenAPI3RouterFactory["create(io.vertx.core.Vertx,java.lang.String,java.util.List,io.vertx.core.Handler)"](__args[0]._jdel, __args[1], utils.convParamListJsonObject(__args[2]), function(ar) {
      if (ar.succeeded()) {
        __prom_completer_handler(utils.convReturnVertxGen(OpenAPI3RouterFactory, ar.result()), null);
      } else {
        __prom_completer_handler(null, ar.cause());
      }
    });
    return __prom.future();
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = OpenAPI3RouterFactory;