/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-common-js/web_environment */
var utils = require('vertx-js/util/utils');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JWebEnvironment = Java.type('io.vertx.ext.web.common.WebEnvironment');

/**
 Utility API to verify which environment is the web application running.

 The utility will check initially for the existence of a system property under the name `vertx.mode`,
 if there is no such property then it will look under the environment variables under the name `VERTX_MODE`.

 This value will be then used when the API is invoked. By itself this utility will not
 affect the behavior of your application, however you can use it to simplify your handlers, e.g.:

 When the development mode is active you can log more information or disable caches.

 @class
*/
var WebEnvironment = function(j_val) {

  var j_webEnvironment = j_val;
  var that = this;

  var __super_development = this.development;
  var __super_mode = this.mode;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_webEnvironment;
};

WebEnvironment._jclass = utils.getJavaClass("io.vertx.ext.web.common.WebEnvironment");
WebEnvironment._jtype = {accept: function(obj) {
    return WebEnvironment._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(WebEnvironment.prototype, {});
    WebEnvironment.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
WebEnvironment._create = function(jdel) {var obj = Object.create(WebEnvironment.prototype, {});
  WebEnvironment.apply(obj, arguments);
  return obj;
}
/**
 Will return true if the mode is not null and equals ignoring case the string "dev"

 @memberof module:vertx-web-common-js/web_environment

 @return {boolean} always boolean
 */
WebEnvironment.development =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return JWebEnvironment["development()"]() ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 The current mode from the system properties with fallback to environment variables

 @memberof module:vertx-web-common-js/web_environment

 @return {string} String with mode value or null
 */
WebEnvironment.mode =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return JWebEnvironment["mode()"]() ;
  }else throw new TypeError('function invoked with invalid arguments');
};

WebEnvironment.SYSTEM_PROPERTY_NAME = JWebEnvironment.SYSTEM_PROPERTY_NAME;
WebEnvironment.ENV_VARIABLE_NAME = JWebEnvironment.ENV_VARIABLE_NAME;
module.exports = WebEnvironment;