/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-amqp-client-js/amqp_connection */
var utils = require('vertx-js/util/utils');
var AmqpMessage = require('vertx-amqp-client-js/amqp_message');
var AmqpSender = require('vertx-amqp-client-js/amqp_sender');
var AmqpReceiver = require('vertx-amqp-client-js/amqp_receiver');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAmqpConnection = Java.type('io.vertx.amqp.AmqpConnection');
var AmqpSenderOptions = Java.type('io.vertx.amqp.AmqpSenderOptions');
var AmqpReceiverOptions = Java.type('io.vertx.amqp.AmqpReceiverOptions');

/**
 Once connected to the broker or router, you get a connection. This connection is automatically opened.

 @class
*/
var AmqpConnection = function(j_val) {

  var j_amqpConnection = j_val;
  var that = this;

  var __super_exceptionHandler = this.exceptionHandler;
  var __super_close = this.close;
  var __super_createReceiver = this.createReceiver;
  var __super_createReceiver = this.createReceiver;
  var __super_createReceiver = this.createReceiver;
  var __super_createReceiver = this.createReceiver;
  var __super_createDynamicReceiver = this.createDynamicReceiver;
  var __super_createSender = this.createSender;
  var __super_createSender = this.createSender;
  var __super_createAnonymousSender = this.createAnonymousSender;
  /**
   Registers a handler called on disconnection.

   @public
   @param handler {function} the exception handler. 
   @return {AmqpConnection}
   */
  this.exceptionHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_amqpConnection["exceptionHandler(io.vertx.core.Handler)"](function(jVal) {
        handler(utils.convReturnThrowable(jVal));
      }) ;
      return that;
    } else if (typeof __super_exceptionHandler != 'undefined') {
      return __super_exceptionHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Closes the AMQP connection, i.e. allows the Close frame to be emitted.

   @public
   @param done {function} the close handler notified when the connection is closed. May be <code>null</code>. 
   @return {AmqpConnection} the connection
   */
  this.close =  function(done) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_amqpConnection["close(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          done(null, null);
        } else {
          done(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpConnection["close(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Creates a receiver used to consumer messages from the given address.

   @public
   @param address {string} The source address to attach the consumer to. 
   @param receiverOptions {Object} The options for this receiver. 
   @param completionHandler {function} The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery. 
   @return {AmqpConnection} the connection.
   */
  this.createReceiver =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_amqpConnection["createReceiver(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpConnection["createReceiver(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'function' && typeof __args[2] === 'function') {
      j_amqpConnection["createReceiver(java.lang.String,io.vertx.core.Handler,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnVertxGen(AmqpMessage, jVal));
      }, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpConnection["createReceiver(java.lang.String,io.vertx.core.Handler,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnVertxGen(AmqpMessage, jVal));
      }, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function' && typeof __args[3] === 'function') {
      j_amqpConnection["createReceiver(java.lang.String,io.vertx.amqp.AmqpReceiverOptions,io.vertx.core.Handler,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new AmqpReceiverOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(jVal) {
        __args[2](utils.convReturnVertxGen(AmqpMessage, jVal));
      }, function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpConnection["createReceiver(java.lang.String,io.vertx.amqp.AmqpReceiverOptions,io.vertx.core.Handler,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new AmqpReceiverOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(jVal) {
        __args[2](utils.convReturnVertxGen(AmqpMessage, jVal));
      }, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_amqpConnection["createReceiver(java.lang.String,io.vertx.amqp.AmqpReceiverOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new AmqpReceiverOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null)) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpConnection["createReceiver(java.lang.String,io.vertx.amqp.AmqpReceiverOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new AmqpReceiverOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_createReceiver != 'undefined') {
      return __super_createReceiver.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Creates a dynamic receiver. The address is provided by the broker and is available in the <code>completionHandler</code>,
   using the {@link AmqpReceiver#address} method. this method is useful for request-reply to generate a unique
   reply address.

   @public
   @param completionHandler {function} the completion handler, called when the receiver has been created and opened. 
   @return {AmqpConnection} the connection.
   */
  this.createDynamicReceiver =  function(completionHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_amqpConnection["createDynamicReceiver(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          completionHandler(utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          completionHandler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpConnection["createDynamicReceiver(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_createDynamicReceiver != 'undefined') {
      return __super_createDynamicReceiver.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   {@link AmqpConnection#createAnonymousSender}.

   @public
   @param address {string} The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker). 
   @param options {Object} The AMQP sender options 
   @param completionHandler {function} The handler called with the sender, once opened 
   @return {AmqpConnection} the connection.
   */
  this.createSender =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_amqpConnection["createSender(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(AmqpSender, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpConnection["createSender(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpSender, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_amqpConnection["createSender(java.lang.String,io.vertx.amqp.AmqpSenderOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new AmqpSenderOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(AmqpSender, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null)) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpConnection["createSender(java.lang.String,io.vertx.amqp.AmqpSenderOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new AmqpSenderOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpSender, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_createSender != 'undefined') {
      return __super_createSender.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Creates an anonymous sender.
   <p>
   Unlike "regular" sender, this sender is not associated to a specific address, and each message sent must provide
   an address. This method can be used in request-reply scenarios where you create a sender to send the reply,
   but you don't know the address, as the reply address is passed into the message you are going to receive.

   @public
   @param completionHandler {function} The handler called with the created sender, once opened 
   @return {AmqpConnection} the connection.
   */
  this.createAnonymousSender =  function(completionHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_amqpConnection["createAnonymousSender(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          completionHandler(utils.convReturnVertxGen(AmqpSender, ar.result()), null);
        } else {
          completionHandler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpConnection["createAnonymousSender(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpSender, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_createAnonymousSender != 'undefined') {
      return __super_createAnonymousSender.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_amqpConnection;
};

AmqpConnection._jclass = utils.getJavaClass("io.vertx.amqp.AmqpConnection");
AmqpConnection._jtype = {accept: function(obj) {
    return AmqpConnection._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(AmqpConnection.prototype, {});
    AmqpConnection.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
AmqpConnection._create = function(jdel) {var obj = Object.create(AmqpConnection.prototype, {});
  AmqpConnection.apply(obj, arguments);
  return obj;
}
module.exports = AmqpConnection;