/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-oauth2-js/keycloak_rbac */
var utils = require('vertx-js/util/utils');
var OAuth2RBAC = require('vertx-auth-oauth2-js/o_auth2_rbac');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JKeycloakRBAC = Java.type('io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC');
var OAuth2ClientOptions = Java.type('io.vertx.ext.auth.oauth2.OAuth2ClientOptions');

/**
 Implementation of the Keycloak RBAC handler.

 @class
*/
var KeycloakRBAC = function(j_val) {

  var j_keycloakRBAC = j_val;
  var that = this;

  var __super_create = this.create;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_keycloakRBAC;
};

KeycloakRBAC._jclass = utils.getJavaClass("io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC");
KeycloakRBAC._jtype = {accept: function(obj) {
    return KeycloakRBAC._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(KeycloakRBAC.prototype, {});
    KeycloakRBAC.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
KeycloakRBAC._create = function(jdel) {var obj = Object.create(KeycloakRBAC.prototype, {});
  KeycloakRBAC.apply(obj, arguments);
  return obj;
}
/**
 Factory method to create a RBAC handler for tokens adhering to the Keycloak token format.

 @memberof module:vertx-auth-oauth2-js/keycloak_rbac
 @param options {Object} 
 @return {OAuth2RBAC} a RBAC validator
 */
KeycloakRBAC.create =  function(options) {
  var __args = arguments;
  if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
    return utils.convReturnVertxGen(OAuth2RBAC, JKeycloakRBAC["create(io.vertx.ext.auth.oauth2.OAuth2ClientOptions)"](options  != null ? new OAuth2ClientOptions(new JsonObject(Java.asJSONCompatible(options))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = KeycloakRBAC;