/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-cassandra-js/result_set */
var utils = require('vertx-js/util/utils');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JResultSet = Java.type('io.vertx.cassandra.ResultSet');

/**

 @class
*/
var ResultSet = function(j_val) {

  var j_resultSet = j_val;
  var that = this;

  var __super_isExhausted = this.isExhausted;
  var __super_isFullyFetched = this.isFullyFetched;
  var __super_getAvailableWithoutFetching = this.getAvailableWithoutFetching;
  var __super_fetchMoreResults = this.fetchMoreResults;
  var __super_wasApplied = this.wasApplied;
  /**

   @public

   @return {boolean}
   */
  this.isExhausted =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_resultSet["isExhausted()"]() ;
    } else if (typeof __super_isExhausted != 'undefined') {
      return __super_isExhausted.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean}
   */
  this.isFullyFetched =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_resultSet["isFullyFetched()"]() ;
    } else if (typeof __super_isFullyFetched != 'undefined') {
      return __super_isFullyFetched.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number}
   */
  this.getAvailableWithoutFetching =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_resultSet["getAvailableWithoutFetching()"]() ;
    } else if (typeof __super_getAvailableWithoutFetching != 'undefined') {
      return __super_getAvailableWithoutFetching.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} handler called when result is fetched 
   @return {ResultSet}
   */
  this.fetchMoreResults =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_resultSet["fetchMoreResults(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_resultSet["fetchMoreResults(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_fetchMoreResults != 'undefined') {
      return __super_fetchMoreResults.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean}
   */
  this.wasApplied =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_resultSet["wasApplied()"]() ;
    } else if (typeof __super_wasApplied != 'undefined') {
      return __super_wasApplied.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_resultSet;
};

ResultSet._jclass = utils.getJavaClass("io.vertx.cassandra.ResultSet");
ResultSet._jtype = {accept: function(obj) {
    return ResultSet._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ResultSet.prototype, {});
    ResultSet.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ResultSet._create = function(jdel) {var obj = Object.create(ResultSet.prototype, {});
  ResultSet.apply(obj, arguments);
  return obj;
}
module.exports = ResultSet;