/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/request_parameters */
var utils = require('vertx-js/util/utils');
var RequestParameter = require('vertx-web-api-contract-js/request_parameter');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JRequestParameters = Java.type('io.vertx.ext.web.api.RequestParameters');

/**
 Container for request parameters

 @class
*/
var RequestParameters = function(j_val) {

  var j_requestParameters = j_val;
  var that = this;

  var __super_pathParametersNames = this.pathParametersNames;
  var __super_pathParameter = this.pathParameter;
  var __super_queryParametersNames = this.queryParametersNames;
  var __super_queryParameter = this.queryParameter;
  var __super_headerParametersNames = this.headerParametersNames;
  var __super_headerParameter = this.headerParameter;
  var __super_cookieParametersNames = this.cookieParametersNames;
  var __super_cookieParameter = this.cookieParameter;
  var __super_formParametersNames = this.formParametersNames;
  var __super_formParameter = this.formParameter;
  var __super_body = this.body;
  var __super_toJson = this.toJson;
  /**
   Get list of all parameter names inside path

   @public

   @return {Array.<string>} 
   */
  this.pathParametersNames =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameters["pathParametersNames()"]() ;
    } else if (typeof __super_pathParametersNames != 'undefined') {
      return __super_pathParametersNames.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get path parameter by name

   @public
   @param name {string} Parameter name 
   @return {RequestParameter} 
   */
  this.pathParameter =  function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["pathParameter(java.lang.String)"](name)) ;
    } else if (typeof __super_pathParameter != 'undefined') {
      return __super_pathParameter.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get list of all parameter names inside query

   @public

   @return {Array.<string>} 
   */
  this.queryParametersNames =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameters["queryParametersNames()"]() ;
    } else if (typeof __super_queryParametersNames != 'undefined') {
      return __super_queryParametersNames.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get query parameter by name

   @public
   @param name {string} Parameter name 
   @return {RequestParameter} 
   */
  this.queryParameter =  function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["queryParameter(java.lang.String)"](name)) ;
    } else if (typeof __super_queryParameter != 'undefined') {
      return __super_queryParameter.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get list of all parameter names inside header

   @public

   @return {Array.<string>} 
   */
  this.headerParametersNames =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameters["headerParametersNames()"]() ;
    } else if (typeof __super_headerParametersNames != 'undefined') {
      return __super_headerParametersNames.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get header parameter by name

   @public
   @param name {string} Parameter name 
   @return {RequestParameter} 
   */
  this.headerParameter =  function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["headerParameter(java.lang.String)"](name)) ;
    } else if (typeof __super_headerParameter != 'undefined') {
      return __super_headerParameter.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get list of all parameter names inside cookie

   @public

   @return {Array.<string>} 
   */
  this.cookieParametersNames =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameters["cookieParametersNames()"]() ;
    } else if (typeof __super_cookieParametersNames != 'undefined') {
      return __super_cookieParametersNames.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get cookie parameter by name

   @public
   @param name {string} Parameter name 
   @return {RequestParameter} 
   */
  this.cookieParameter =  function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["cookieParameter(java.lang.String)"](name)) ;
    } else if (typeof __super_cookieParameter != 'undefined') {
      return __super_cookieParameter.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get list of all parameter names inside body form

   @public

   @return {Array.<string>} 
   */
  this.formParametersNames =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameters["formParametersNames()"]() ;
    } else if (typeof __super_formParametersNames != 'undefined') {
      return __super_formParametersNames.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get form parameter by name

   @public
   @param name {string} Parameter name 
   @return {RequestParameter} 
   */
  this.formParameter =  function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["formParameter(java.lang.String)"](name)) ;
    } else if (typeof __super_formParameter != 'undefined') {
      return __super_formParameter.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Return request body

   @public

   @return {RequestParameter} 
   */
  this.body =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["body()"]()) ;
    } else if (typeof __super_body != 'undefined') {
      return __super_body.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   This method converts RequestParameters in an unique JsonObject with 6 fields: cookie, path, query, header, form, body<br/>

   cookie, path, query, header, form are JsonObject where keys are param names and values are param values, while body depends on body's shape and may not exist

   @public

   @return {Object} 
   */
  this.toJson =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedtoJson == null) {
        that.cachedtoJson = utils.convReturnJson(j_requestParameters["toJson()"]());
      }
      return that.cachedtoJson;
    } else if (typeof __super_toJson != 'undefined') {
      return __super_toJson.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_requestParameters;
};

RequestParameters._jclass = utils.getJavaClass("io.vertx.ext.web.api.RequestParameters");
RequestParameters._jtype = {accept: function(obj) {
    return RequestParameters._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(RequestParameters.prototype, {});
    RequestParameters.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
RequestParameters._create = function(jdel) {var obj = Object.create(RequestParameters.prototype, {});
  RequestParameters.apply(obj, arguments);
  return obj;
}
module.exports = RequestParameters;