/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-client-js/web_client */
var utils = require('vertx-js/util/utils');
var Buffer = require('vertx-js/buffer');
var Vertx = require('vertx-js/vertx');
var HttpClient = require('vertx-js/http_client');
var HttpRequest = require('vertx-web-client-js/http_request');
var SocketAddress = require('vertx-js/socket_address');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JWebClient = Java.type('io.vertx.ext.web.client.WebClient');
var WebClientOptions = Java.type('io.vertx.ext.web.client.WebClientOptions');
var RequestOptions = Java.type('io.vertx.core.http.RequestOptions');

/**

 @class
*/
var WebClient = function(j_val) {

  var j_webClient = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_wrap = this.wrap;
  var __super_wrap = this.wrap;
  var __super_request = this.request;
  var __super_request = this.request;
  var __super_request = this.request;
  var __super_request = this.request;
  var __super_request = this.request;
  var __super_request = this.request;
  var __super_request = this.request;
  var __super_request = this.request;
  var __super_requestAbs = this.requestAbs;
  var __super_requestAbs = this.requestAbs;
  var __super_get = this.get;
  var __super_get = this.get;
  var __super_get = this.get;
  var __super_getAbs = this.getAbs;
  var __super_post = this.post;
  var __super_post = this.post;
  var __super_post = this.post;
  var __super_postAbs = this.postAbs;
  var __super_put = this.put;
  var __super_put = this.put;
  var __super_put = this.put;
  var __super_putAbs = this.putAbs;
  var __super_delete = this.delete;
  var __super_delete = this.delete;
  var __super_delete = this.delete;
  var __super_deleteAbs = this.deleteAbs;
  var __super_patch = this.patch;
  var __super_patch = this.patch;
  var __super_patch = this.patch;
  var __super_patchAbs = this.patchAbs;
  var __super_head = this.head;
  var __super_head = this.head;
  var __super_head = this.head;
  var __super_headAbs = this.headAbs;
  var __super_raw = this.raw;
  var __super_raw = this.raw;
  var __super_raw = this.raw;
  var __super_rawAbs = this.rawAbs;
  var __super_close = this.close;
  /**
   Like {@link WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   server instead of the <code>options</code> parameter.
   <p>
   The request host header will still be created from the <code>options</code> parameter.
   <p>
   Use  to connect to a unix domain socket server.

   @public
   @param method {Object} 
   @param serverAddress {SocketAddress} 
   @param options {Object} 
   @return {HttpRequest}
   */
  this.request =  function() {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] ==='number' && typeof __args[2] === 'string' && typeof __args[3] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["request(io.vertx.core.http.HttpMethod,int,java.lang.String,java.lang.String)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1], __args[2], __args[3]), Buffer._jtype) ;
    } else if (__args.length === 5 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] ==='number' && typeof __args[3] === 'string' && typeof __args[4] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["request(io.vertx.core.http.HttpMethod,io.vertx.core.net.SocketAddress,int,java.lang.String,java.lang.String)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1]._jdel, __args[2], __args[3], __args[4]), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["request(io.vertx.core.http.HttpMethod,java.lang.String,java.lang.String)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1], __args[2]), Buffer._jtype) ;
    } else if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'string' && typeof __args[3] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["request(io.vertx.core.http.HttpMethod,io.vertx.core.net.SocketAddress,java.lang.String,java.lang.String)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1]._jdel, __args[2], __args[3]), Buffer._jtype) ;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["request(io.vertx.core.http.HttpMethod,java.lang.String)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1]), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["request(io.vertx.core.http.HttpMethod,io.vertx.core.net.SocketAddress,java.lang.String)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1]._jdel, __args[2]), Buffer._jtype) ;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null)) {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["request(io.vertx.core.http.HttpMethod,io.vertx.core.http.RequestOptions)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1]  != null ? new RequestOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && (typeof __args[2] === 'object' && __args[2] != null)) {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["request(io.vertx.core.http.HttpMethod,io.vertx.core.net.SocketAddress,io.vertx.core.http.RequestOptions)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1]._jdel, __args[2]  != null ? new RequestOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null), Buffer._jtype) ;
    } else if (typeof __super_request != 'undefined') {
      return __super_request.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Like {@link WebClient#requestAbs} using the <code>serverAddress</code> parameter to connect to the
   server instead of the <code>absoluteURI</code> parameter.
   <p>
   The request host header will still be created from the <code>absoluteURI</code> parameter.
   <p>
   Use  to connect to a unix domain socket server.

   @public
   @param method {Object} 
   @param serverAddress {SocketAddress} 
   @param absoluteURI {string} 
   @return {HttpRequest}
   */
  this.requestAbs =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["requestAbs(io.vertx.core.http.HttpMethod,java.lang.String)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1]), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["requestAbs(io.vertx.core.http.HttpMethod,io.vertx.core.net.SocketAddress,java.lang.String)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1]._jdel, __args[2]), Buffer._jtype) ;
    } else if (typeof __super_requestAbs != 'undefined') {
      return __super_requestAbs.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP GET request to send to the server at the specified host and default port.

   @public
   @param host {string} the host 
   @param requestURI {string} the relative URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.get =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["get(java.lang.String)"](__args[0]), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["get(int,java.lang.String,java.lang.String)"](__args[0], __args[1], __args[2]), Buffer._jtype) ;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["get(java.lang.String,java.lang.String)"](__args[0], __args[1]), Buffer._jtype) ;
    } else if (typeof __super_get != 'undefined') {
      return __super_get.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP GET request to send to the server using an absolute URI, specifying a response handler to receive
   the response

   @public
   @param absoluteURI {string} the absolute URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.getAbs =  function(absoluteURI) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["getAbs(java.lang.String)"](absoluteURI), Buffer._jtype) ;
    } else if (typeof __super_getAbs != 'undefined') {
      return __super_getAbs.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP POST request to send to the server at the specified host and default port.

   @public
   @param host {string} the host 
   @param requestURI {string} the relative URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.post =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["post(java.lang.String)"](__args[0]), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["post(int,java.lang.String,java.lang.String)"](__args[0], __args[1], __args[2]), Buffer._jtype) ;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["post(java.lang.String,java.lang.String)"](__args[0], __args[1]), Buffer._jtype) ;
    } else if (typeof __super_post != 'undefined') {
      return __super_post.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP POST request to send to the server using an absolute URI, specifying a response handler to receive
   the response

   @public
   @param absoluteURI {string} the absolute URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.postAbs =  function(absoluteURI) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["postAbs(java.lang.String)"](absoluteURI), Buffer._jtype) ;
    } else if (typeof __super_postAbs != 'undefined') {
      return __super_postAbs.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP PUT request to send to the server at the specified host and default port.

   @public
   @param host {string} the host 
   @param requestURI {string} the relative URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.put =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["put(java.lang.String)"](__args[0]), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["put(int,java.lang.String,java.lang.String)"](__args[0], __args[1], __args[2]), Buffer._jtype) ;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["put(java.lang.String,java.lang.String)"](__args[0], __args[1]), Buffer._jtype) ;
    } else if (typeof __super_put != 'undefined') {
      return __super_put.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP PUT request to send to the server using an absolute URI, specifying a response handler to receive
   the response

   @public
   @param absoluteURI {string} the absolute URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.putAbs =  function(absoluteURI) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["putAbs(java.lang.String)"](absoluteURI), Buffer._jtype) ;
    } else if (typeof __super_putAbs != 'undefined') {
      return __super_putAbs.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP DELETE request to send to the server at the specified host and default port.

   @public
   @param host {string} the host 
   @param requestURI {string} the relative URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.delete =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["delete(java.lang.String)"](__args[0]), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["delete(int,java.lang.String,java.lang.String)"](__args[0], __args[1], __args[2]), Buffer._jtype) ;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["delete(java.lang.String,java.lang.String)"](__args[0], __args[1]), Buffer._jtype) ;
    } else if (typeof __super_delete != 'undefined') {
      return __super_delete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP DELETE request to send to the server using an absolute URI, specifying a response handler to receive
   the response

   @public
   @param absoluteURI {string} the absolute URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.deleteAbs =  function(absoluteURI) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["deleteAbs(java.lang.String)"](absoluteURI), Buffer._jtype) ;
    } else if (typeof __super_deleteAbs != 'undefined') {
      return __super_deleteAbs.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP PATCH request to send to the server at the specified host and default port.

   @public
   @param host {string} the host 
   @param requestURI {string} the relative URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.patch =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["patch(java.lang.String)"](__args[0]), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["patch(int,java.lang.String,java.lang.String)"](__args[0], __args[1], __args[2]), Buffer._jtype) ;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["patch(java.lang.String,java.lang.String)"](__args[0], __args[1]), Buffer._jtype) ;
    } else if (typeof __super_patch != 'undefined') {
      return __super_patch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP PATCH request to send to the server using an absolute URI, specifying a response handler to receive
   the response

   @public
   @param absoluteURI {string} the absolute URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.patchAbs =  function(absoluteURI) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["patchAbs(java.lang.String)"](absoluteURI), Buffer._jtype) ;
    } else if (typeof __super_patchAbs != 'undefined') {
      return __super_patchAbs.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP HEAD request to send to the server at the specified host and default port.

   @public
   @param host {string} the host 
   @param requestURI {string} the relative URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.head =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["head(java.lang.String)"](__args[0]), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["head(int,java.lang.String,java.lang.String)"](__args[0], __args[1], __args[2]), Buffer._jtype) ;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["head(java.lang.String,java.lang.String)"](__args[0], __args[1]), Buffer._jtype) ;
    } else if (typeof __super_head != 'undefined') {
      return __super_head.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create an HTTP HEAD request to send to the server using an absolute URI, specifying a response handler to receive
   the response

   @public
   @param absoluteURI {string} the absolute URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.headAbs =  function(absoluteURI) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["headAbs(java.lang.String)"](absoluteURI), Buffer._jtype) ;
    } else if (typeof __super_headAbs != 'undefined') {
      return __super_headAbs.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create a request with a custom HTTP method  to send to the server at the specified host and default port.

   @public
   @param customHttpMethod {string} custom HTTP Method 
   @param host {string} the host 
   @param requestURI {string} the relative URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.raw =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["raw(java.lang.String,java.lang.String)"](__args[0], __args[1]), Buffer._jtype) ;
    } else if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] ==='number' && typeof __args[2] === 'string' && typeof __args[3] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["raw(java.lang.String,int,java.lang.String,java.lang.String)"](__args[0], __args[1], __args[2], __args[3]), Buffer._jtype) ;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["raw(java.lang.String,java.lang.String,java.lang.String)"](__args[0], __args[1], __args[2]), Buffer._jtype) ;
    } else if (typeof __super_raw != 'undefined') {
      return __super_raw.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create a request with a custom HTTP method  to send to the server using an absolute URI, specifying a response handler to receive
   the response

   @public
   @param customHttpMethod {string} custom HTTP Method 
   @param absoluteURI {string} the absolute URI 
   @return {HttpRequest} an HTTP client request object
   */
  this.rawAbs =  function(customHttpMethod, absoluteURI) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(HttpRequest, j_webClient["rawAbs(java.lang.String,java.lang.String)"](customHttpMethod, absoluteURI), Buffer._jtype) ;
    } else if (typeof __super_rawAbs != 'undefined') {
      return __super_rawAbs.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Close the client. Closing will close down any pooled connections.
   Clients should always be closed after use.

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_webClient["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_webClient;
};

WebClient._jclass = utils.getJavaClass("io.vertx.ext.web.client.WebClient");
WebClient._jtype = {accept: function(obj) {
    return WebClient._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(WebClient.prototype, {});
    WebClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
WebClient._create = function(jdel) {var obj = Object.create(WebClient.prototype, {});
  WebClient.apply(obj, arguments);
  return obj;
}
/**
 Create a web client using the provided <code>vertx</code> instance.

 @memberof module:vertx-web-client-js/web_client
 @param vertx {Vertx} the vertx instance 
 @param options {Object} the Web Client options 
 @return {WebClient} the created web client
 */
WebClient.create =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(WebClient, JWebClient["create(io.vertx.core.Vertx)"](__args[0]._jdel)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(WebClient, JWebClient["create(io.vertx.core.Vertx,io.vertx.ext.web.client.WebClientOptions)"](__args[0]._jdel, __args[1]  != null ? new WebClientOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Wrap an <code>httpClient</code> with a web client and default options.
 <p>
 Only the specific web client portion of the <code>options</code> is used, the <a href="../../dataobjects.html#HttpClientOptions">HttpClientOptions</a>
 of the <code>httpClient</code> is reused.

 @memberof module:vertx-web-client-js/web_client
 @param httpClient {HttpClient} the  to wrap 
 @param options {Object} the Web Client options 
 @return {WebClient} the web client
 */
WebClient.wrap =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(WebClient, JWebClient["wrap(io.vertx.core.http.HttpClient)"](__args[0]._jdel)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(WebClient, JWebClient["wrap(io.vertx.core.http.HttpClient,io.vertx.ext.web.client.WebClientOptions)"](__args[0]._jdel, __args[1]  != null ? new WebClientOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = WebClient;