/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-js/method_override_handler */
var utils = require('vertx-js/util/utils');
var RoutingContext = require('vertx-web-js/routing_context');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JMethodOverrideHandler = Java.type('io.vertx.ext.web.handler.MethodOverrideHandler');

/**

 @class
*/
var MethodOverrideHandler = function(j_val) {

  var j_methodOverrideHandler = j_val;
  var that = this;

  var __super_handle = this.handle;
  var __super_create = this.create;
  var __super_create = this.create;
  /**
   Something has happened, so handle it.

   @public
   @param event {RoutingContext} the event to handle 
   */
  this.handle =  function(event) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_methodOverrideHandler["handle(io.vertx.ext.web.RoutingContext)"](event._jdel);
    } else if (typeof __super_handle != 'undefined') {
      return __super_handle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_methodOverrideHandler;
};

MethodOverrideHandler._jclass = utils.getJavaClass("io.vertx.ext.web.handler.MethodOverrideHandler");
MethodOverrideHandler._jtype = {accept: function(obj) {
    return MethodOverrideHandler._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(MethodOverrideHandler.prototype, {});
    MethodOverrideHandler.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MethodOverrideHandler._create = function(jdel) {var obj = Object.create(MethodOverrideHandler.prototype, {});
  MethodOverrideHandler.apply(obj, arguments);
  return obj;
}
/**
 Create a X-HTTP-METHOD-OVERRIDE handler

 @memberof module:vertx-web-js/method_override_handler
 @param useSafeDowngrade {boolean} if set to true, the method overriding will not happen if the overridden method is more idempotent or safer than the overriding method. 
 @return {MethodOverrideHandler} the X-HTTP-METHOD-OVERRIDE handler
 */
MethodOverrideHandler.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(MethodOverrideHandler, JMethodOverrideHandler["create()"]()) ;
  } else if (__args.length === 1 && typeof __args[0] ==='boolean') {
    return utils.convReturnVertxGen(MethodOverrideHandler, JMethodOverrideHandler["create(boolean)"](__args[0])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = MethodOverrideHandler;