/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-rabbitmq-js/rabbit_mq_message */
var utils = require('vertx-js/util/utils');
var Envelope = require('vertx-rabbitmq-js/envelope');
var Buffer = require('vertx-js/buffer');
var BasicProperties = require('vertx-rabbitmq-js/basic_properties');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JRabbitMQMessage = Java.type('io.vertx.rabbitmq.RabbitMQMessage');

/**
 Represent a message received message received in a rabbitmq-queue.

 @class
*/
var RabbitMQMessage = function(j_val) {

  var j_rabbitMQMessage = j_val;
  var that = this;

  var __super_body = this.body;
  var __super_consumerTag = this.consumerTag;
  var __super_envelope = this.envelope;
  var __super_properties = this.properties;
  /**

   @public

   @return {Buffer} the message body
   */
  this.body =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedbody == null) {
        that.cachedbody = utils.convReturnVertxGen(Buffer, j_rabbitMQMessage["body()"]());
      }
      return that.cachedbody;
    } else if (typeof __super_body != 'undefined') {
      return __super_body.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the <i>consumer tag</i> associated with the consumer
   */
  this.consumerTag =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedconsumerTag == null) {
        that.cachedconsumerTag = j_rabbitMQMessage["consumerTag()"]();
      }
      return that.cachedconsumerTag;
    } else if (typeof __super_consumerTag != 'undefined') {
      return __super_consumerTag.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Envelope} packaging data for the message
   */
  this.envelope =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedenvelope == null) {
        that.cachedenvelope = utils.convReturnVertxGen(Envelope, j_rabbitMQMessage["envelope()"]());
      }
      return that.cachedenvelope;
    } else if (typeof __super_envelope != 'undefined') {
      return __super_envelope.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {BasicProperties} content header data for the message
   */
  this.properties =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedproperties == null) {
        that.cachedproperties = utils.convReturnVertxGen(BasicProperties, j_rabbitMQMessage["properties()"]());
      }
      return that.cachedproperties;
    } else if (typeof __super_properties != 'undefined') {
      return __super_properties.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_rabbitMQMessage;
};

RabbitMQMessage._jclass = utils.getJavaClass("io.vertx.rabbitmq.RabbitMQMessage");
RabbitMQMessage._jtype = {accept: function(obj) {
    return RabbitMQMessage._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(RabbitMQMessage.prototype, {});
    RabbitMQMessage.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
RabbitMQMessage._create = function(jdel) {var obj = Object.create(RabbitMQMessage.prototype, {});
  RabbitMQMessage.apply(obj, arguments);
  return obj;
}
module.exports = RabbitMQMessage;