/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-client-js/http_response */
var utils = require('vertx-js/util/utils');
var Buffer = require('vertx-js/buffer');
var MultiMap = require('vertx-js/multi_map');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JHttpResponse = Java.type('io.vertx.ext.web.client.HttpResponse');

/**
 An HTTP response.
 <p>
 The usual HTTP response attributes are available:
 <ul>
 @class
*/
var HttpResponse = function(j_val, j_arg_0) {

  var j_httpResponse = j_val;
  var that = this;
  var j_T = typeof j_arg_0 !== 'undefined' ? j_arg_0 : utils.unknown_jtype;
  var __super_version = this.version;
  var __super_statusCode = this.statusCode;
  var __super_statusMessage = this.statusMessage;
  var __super_headers = this.headers;
  var __super_getHeader = this.getHeader;
  var __super_trailers = this.trailers;
  var __super_getTrailer = this.getTrailer;
  var __super_cookies = this.cookies;
  var __super_body = this.body;
  var __super_bodyAsBuffer = this.bodyAsBuffer;
  var __super_followedRedirects = this.followedRedirects;
  var __super_bodyAsString = this.bodyAsString;
  var __super_bodyAsString = this.bodyAsString;
  var __super_bodyAsJsonObject = this.bodyAsJsonObject;
  var __super_bodyAsJsonArray = this.bodyAsJsonArray;
  var __super_bodyAsJson = this.bodyAsJson;
  /**

   @public

   @return {Object} the version of the response
   */
  this.version =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedversion == null) {
        that.cachedversion = utils.convReturnEnum(j_httpResponse["version()"]());
      }
      return that.cachedversion;
    } else if (typeof __super_version != 'undefined') {
      return __super_version.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the status code of the response
   */
  this.statusCode =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedstatusCode == null) {
        that.cachedstatusCode = j_httpResponse["statusCode()"]();
      }
      return that.cachedstatusCode;
    } else if (typeof __super_statusCode != 'undefined') {
      return __super_statusCode.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the status message of the response
   */
  this.statusMessage =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedstatusMessage == null) {
        that.cachedstatusMessage = j_httpResponse["statusMessage()"]();
      }
      return that.cachedstatusMessage;
    } else if (typeof __super_statusMessage != 'undefined') {
      return __super_statusMessage.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {MultiMap} the headers
   */
  this.headers =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedheaders == null) {
        that.cachedheaders = utils.convReturnVertxGen(MultiMap, j_httpResponse["headers()"]());
      }
      return that.cachedheaders;
    } else if (typeof __super_headers != 'undefined') {
      return __super_headers.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Return the first header value with the specified name

   @public
   @param headerName {string} the header name 
   @return {string} the header value
   */
  this.getHeader =  function(headerName) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_httpResponse["getHeader(java.lang.String)"](headerName) ;
    } else if (typeof __super_getHeader != 'undefined') {
      return __super_getHeader.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {MultiMap} the trailers
   */
  this.trailers =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedtrailers == null) {
        that.cachedtrailers = utils.convReturnVertxGen(MultiMap, j_httpResponse["trailers()"]());
      }
      return that.cachedtrailers;
    } else if (typeof __super_trailers != 'undefined') {
      return __super_trailers.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Return the first trailer value with the specified name

   @public
   @param trailerName {string} the trailer name 
   @return {string} the trailer value
   */
  this.getTrailer =  function(trailerName) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_httpResponse["getTrailer(java.lang.String)"](trailerName) ;
    } else if (typeof __super_getTrailer != 'undefined') {
      return __super_getTrailer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<string>} the Set-Cookie headers (including trailers)
   */
  this.cookies =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedcookies == null) {
        that.cachedcookies = j_httpResponse["cookies()"]();
      }
      return that.cachedcookies;
    } else if (typeof __super_cookies != 'undefined') {
      return __super_cookies.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object} the response body in the format it was decoded.
   */
  this.body =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedbody == null) {
        that.cachedbody = j_T.wrap(j_httpResponse["body()"]());
      }
      return that.cachedbody;
    } else if (typeof __super_body != 'undefined') {
      return __super_body.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Buffer} the response body decoded as a , or <code>null</code> if a codec other than  was used
   */
  this.bodyAsBuffer =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedbodyAsBuffer == null) {
        that.cachedbodyAsBuffer = utils.convReturnVertxGen(Buffer, j_httpResponse["bodyAsBuffer()"]());
      }
      return that.cachedbodyAsBuffer;
    } else if (typeof __super_bodyAsBuffer != 'undefined') {
      return __super_bodyAsBuffer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<string>} the list of all followed redirects, including the final location.
   */
  this.followedRedirects =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedfollowedRedirects == null) {
        that.cachedfollowedRedirects = j_httpResponse["followedRedirects()"]();
      }
      return that.cachedfollowedRedirects;
    } else if (typeof __super_followedRedirects != 'undefined') {
      return __super_followedRedirects.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param encoding {string} 
   @return {string} the response body decoded as a <code>String</code> given a specific <code>encoding</code>, or <code>null</code> if a codec other than  was used
   */
  this.bodyAsString =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedbodyAsString == null) {
        that.cachedbodyAsString = j_httpResponse["bodyAsString()"]();
      }
      return that.cachedbodyAsString;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_httpResponse["bodyAsString(java.lang.String)"](__args[0]) ;
    } else if (typeof __super_bodyAsString != 'undefined') {
      return __super_bodyAsString.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object} the response body decoded as , or <code>null</code> if a codec other than  was used
   */
  this.bodyAsJsonObject =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedbodyAsJsonObject == null) {
        that.cachedbodyAsJsonObject = utils.convReturnJson(j_httpResponse["bodyAsJsonObject()"]());
      }
      return that.cachedbodyAsJsonObject;
    } else if (typeof __super_bodyAsJsonObject != 'undefined') {
      return __super_bodyAsJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array} the response body decoded as a , or <code>null</code> if a codec other than  was used
   */
  this.bodyAsJsonArray =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedbodyAsJsonArray == null) {
        that.cachedbodyAsJsonArray = utils.convReturnJson(j_httpResponse["bodyAsJsonArray()"]());
      }
      return that.cachedbodyAsJsonArray;
    } else if (typeof __super_bodyAsJsonArray != 'undefined') {
      return __super_bodyAsJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param type {todo} 
   @return {Object} the response body decoded as the specified <code>type</code> with the Jackson mapper, or <code>null</code> if a codec other than  was used
   */
  this.bodyAsJson =  function(type) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.get_jtype(__args[0]).wrap(j_httpResponse["bodyAsJson(java.lang.Class)"](utils.get_jclass(type))) ;
    } else if (typeof __super_bodyAsJson != 'undefined') {
      return __super_bodyAsJson.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_httpResponse;
};

HttpResponse._jclass = utils.getJavaClass("io.vertx.ext.web.client.HttpResponse");
HttpResponse._jtype = {accept: function(obj) {
    return HttpResponse._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(HttpResponse.prototype, {});
    HttpResponse.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
HttpResponse._create = function(jdel) {var obj = Object.create(HttpResponse.prototype, {});
  HttpResponse.apply(obj, arguments);
  return obj;
}
module.exports = HttpResponse;