/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-oauth2-js/azure_ad_auth */
var utils = require('vertx-js/util/utils');
var OpenIDConnectAuth = require('vertx-auth-oauth2-js/open_id_connect_auth');
var Vertx = require('vertx-js/vertx');
var OAuth2Auth = require('vertx-auth-oauth2-js/o_auth2_auth');
var Future = require('vertx-js/future');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAzureADAuth = Java.type('io.vertx.ext.auth.oauth2.providers.AzureADAuth');
var HttpClientOptions = Java.type('io.vertx.core.http.HttpClientOptions');
var OAuth2ClientOptions = Java.type('io.vertx.ext.auth.oauth2.OAuth2ClientOptions');

/**

 @class
*/
var AzureADAuth = function(j_val) {

  var j_azureADAuth = j_val;
  var that = this;
  OpenIDConnectAuth.call(this, j_val);

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_discover = this.discover;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_azureADAuth;
};

AzureADAuth._jclass = utils.getJavaClass("io.vertx.ext.auth.oauth2.providers.AzureADAuth");
AzureADAuth._jtype = {accept: function(obj) {
    return AzureADAuth._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(AzureADAuth.prototype, {});
    AzureADAuth.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
AzureADAuth._create = function(jdel) {var obj = Object.create(AzureADAuth.prototype, {});
  AzureADAuth.apply(obj, arguments);
  return obj;
}
/**
 Create a OAuth2Auth provider for Microsoft Azure Active Directory

 @memberof module:vertx-auth-oauth2-js/azure_ad_auth
 @param vertx {Vertx} 
 @param clientId {string} the client id given to you by Azure 
 @param clientSecret {string} the client secret given to you by Azure 
 @param guid {string} the guid of your application given to you by Azure 
 @param httpClientOptions {Object} custom http client options 
 @return {OAuth2Auth}
 */
AzureADAuth.create =  function() {
  var __args = arguments;
  if (__args.length === 4 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'string') {
    return utils.convReturnVertxGen(OAuth2Auth, JAzureADAuth["create(io.vertx.core.Vertx,java.lang.String,java.lang.String,java.lang.String)"](__args[0]._jdel, __args[1], __args[2], __args[3])) ;
  } else if (__args.length === 5 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'string' && (typeof __args[4] === 'object' && __args[4] != null)) {
    return utils.convReturnVertxGen(OAuth2Auth, JAzureADAuth["create(io.vertx.core.Vertx,java.lang.String,java.lang.String,java.lang.String,io.vertx.core.http.HttpClientOptions)"](__args[0]._jdel, __args[1], __args[2], __args[3], __args[4]  != null ? new HttpClientOptions(new JsonObject(Java.asJSONCompatible(__args[4]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
 configuration options and attempt to load the well known descriptor. If a site is provided (for example when
 running on a custom instance) that site will be used to do the lookup.
 <p>
 If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
 into the OAuth provider so tokens can be decoded.

 @memberof module:vertx-auth-oauth2-js/azure_ad_auth
 @param vertx {Vertx} the vertx instance 
 @param config {Object} the initial config 
 @param handler {function} the instantiated Oauth2 provider instance handler 
 */
AzureADAuth.discover =  function(vertx, config, handler) {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
    JAzureADAuth["discover(io.vertx.core.Vertx,io.vertx.ext.auth.oauth2.OAuth2ClientOptions,io.vertx.core.Handler)"](vertx._jdel, config  != null ? new OAuth2ClientOptions(new JsonObject(Java.asJSONCompatible(config))) : null, function(ar) {
      if (ar.succeeded()) {
        handler(utils.convReturnVertxGen(OAuth2Auth, ar.result()), null);
      } else {
        handler(null, ar.cause());
      }
    });
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    var __prom = Promise.promise();
    var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
    JAzureADAuth["discover(io.vertx.core.Vertx,io.vertx.ext.auth.oauth2.OAuth2ClientOptions,io.vertx.core.Handler)"](vertx._jdel, config  != null ? new OAuth2ClientOptions(new JsonObject(Java.asJSONCompatible(config))) : null, function(ar) {
      if (ar.succeeded()) {
        __prom_completer_handler(utils.convReturnVertxGen(OAuth2Auth, ar.result()), null);
      } else {
        __prom_completer_handler(null, ar.cause());
      }
    });
    return __prom.future();
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = AzureADAuth;