/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/request_parameter */
var utils = require('vertx-js/util/utils');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JRequestParameter = Java.type('io.vertx.ext.web.api.RequestParameter');

/**
 Request parameter holder

 @class
*/
var RequestParameter = function(j_val) {

  var j_requestParameter = j_val;
  var that = this;

  var __super_setName = this.setName;
  var __super_setValue = this.setValue;
  var __super_getName = this.getName;
  var __super_getObjectKeys = this.getObjectKeys;
  var __super_getObjectValue = this.getObjectValue;
  var __super_isObject = this.isObject;
  var __super_getArray = this.getArray;
  var __super_isArray = this.isArray;
  var __super_getString = this.getString;
  var __super_isString = this.isString;
  var __super_getInteger = this.getInteger;
  var __super_isInteger = this.isInteger;
  var __super_getLong = this.getLong;
  var __super_isLong = this.isLong;
  var __super_getFloat = this.getFloat;
  var __super_isFloat = this.isFloat;
  var __super_getDouble = this.getDouble;
  var __super_isDouble = this.isDouble;
  var __super_getBoolean = this.getBoolean;
  var __super_isBoolean = this.isBoolean;
  var __super_getJsonObject = this.getJsonObject;
  var __super_isJsonObject = this.isJsonObject;
  var __super_getJsonArray = this.getJsonArray;
  var __super_isJsonArray = this.isJsonArray;
  var __super_isNull = this.isNull;
  var __super_isEmpty = this.isEmpty;
  var __super_toJson = this.toJson;
  var __super_merge = this.merge;
  var __super_create = this.create;
  var __super_create = this.create;
  /**
   Set parameter name

   @public
   @param name {string} 
   */
  this.setName =  function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_requestParameter["setName(java.lang.String)"](name);
    } else if (typeof __super_setName != 'undefined') {
      return __super_setName.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set value

   @public
   @param value {Object} 
   */
  this.setValue =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] !== 'function') {
      j_requestParameter["setValue(java.lang.Object)"](utils.convParamTypeUnknown(value));
    } else if (typeof __super_setValue != 'undefined') {
      return __super_setValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get parameter name

   @public

   @return {string} 
   */
  this.getName =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getName()"]() ;
    } else if (typeof __super_getName != 'undefined') {
      return __super_getName.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   If value is a map of fields, it returns keys of map, otherwise it returns null

   @public

   @return {Array.<string>} 
   */
  this.getObjectKeys =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getObjectKeys()"]() ;
    } else if (typeof __super_getObjectKeys != 'undefined') {
      return __super_getObjectKeys.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   If value is a map of fields, it returns value of field with key provided, otherwise it returns null

   @public
   @param key {string} 
   @return {RequestParameter} 
   */
  this.getObjectValue =  function(key) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameter["getObjectValue(java.lang.String)"](key)) ;
    } else if (typeof __super_getObjectValue != 'undefined') {
      return __super_getObjectValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a map of fields

   @public

   @return {boolean} 
   */
  this.isObject =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isObject()"]() ;
    } else if (typeof __super_isObject != 'undefined') {
      return __super_isObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a list, otherwise it returns value

   @public

   @return {Array.<RequestParameter>} 
   */
  this.getArray =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetVertxGen(j_requestParameter["getArray()"](), RequestParameter) ;
    } else if (typeof __super_getArray != 'undefined') {
      return __super_getArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is an array

   @public

   @return {boolean} 
   */
  this.isArray =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isArray()"]() ;
    } else if (typeof __super_isArray != 'undefined') {
      return __super_isArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a String, otherwise it returns value

   @public

   @return {string} 
   */
  this.getString =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getString()"]() ;
    } else if (typeof __super_getString != 'undefined') {
      return __super_getString.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a String instance

   @public

   @return {boolean} 
   */
  this.isString =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isString()"]() ;
    } else if (typeof __super_isString != 'undefined') {
      return __super_isString.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not an Integer, otherwise it returns value

   @public

   @return {number} 
   */
  this.getInteger =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getInteger()"]() ;
    } else if (typeof __super_getInteger != 'undefined') {
      return __super_getInteger.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is an Integer instance

   @public

   @return {boolean} 
   */
  this.isInteger =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isInteger()"]() ;
    } else if (typeof __super_isInteger != 'undefined') {
      return __super_isInteger.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a Long, otherwise it returns value

   @public

   @return {number} 
   */
  this.getLong =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnLong(j_requestParameter["getLong()"]()) ;
    } else if (typeof __super_getLong != 'undefined') {
      return __super_getLong.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a Long instance

   @public

   @return {boolean} 
   */
  this.isLong =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isLong()"]() ;
    } else if (typeof __super_isLong != 'undefined') {
      return __super_isLong.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a Float, otherwise it returns value

   @public

   @return {number} 
   */
  this.getFloat =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getFloat()"]() ;
    } else if (typeof __super_getFloat != 'undefined') {
      return __super_getFloat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a Float instance

   @public

   @return {boolean} 
   */
  this.isFloat =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isFloat()"]() ;
    } else if (typeof __super_isFloat != 'undefined') {
      return __super_isFloat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a Double, otherwise it returns value

   @public

   @return {number} 
   */
  this.getDouble =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getDouble()"]() ;
    } else if (typeof __super_getDouble != 'undefined') {
      return __super_getDouble.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a Double instance

   @public

   @return {boolean} 
   */
  this.isDouble =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isDouble()"]() ;
    } else if (typeof __super_isDouble != 'undefined') {
      return __super_isDouble.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a Boolean, otherwise it returns value

   @public

   @return {boolean} 
   */
  this.getBoolean =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getBoolean()"]() ;
    } else if (typeof __super_getBoolean != 'undefined') {
      return __super_getBoolean.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a Boolean instance

   @public

   @return {boolean} 
   */
  this.isBoolean =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isBoolean()"]() ;
    } else if (typeof __super_isBoolean != 'undefined') {
      return __super_isBoolean.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a JsonObject, otherwise it returns value

   @public

   @return {Object} 
   */
  this.getJsonObject =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_requestParameter["getJsonObject()"]()) ;
    } else if (typeof __super_getJsonObject != 'undefined') {
      return __super_getJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a JsonObject instance

   @public

   @return {boolean} 
   */
  this.isJsonObject =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isJsonObject()"]() ;
    } else if (typeof __super_isJsonObject != 'undefined') {
      return __super_isJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a JsonArray, otherwise it returns value

   @public

   @return {Array} 
   */
  this.getJsonArray =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_requestParameter["getJsonArray()"]()) ;
    } else if (typeof __super_getJsonArray != 'undefined') {
      return __super_getJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a JsonArray instance

   @public

   @return {boolean} 
   */
  this.isJsonArray =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isJsonArray()"]() ;
    } else if (typeof __super_isJsonArray != 'undefined') {
      return __super_isJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value is null

   @public

   @return {boolean} 
   */
  this.isNull =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isNull()"]() ;
    } else if (typeof __super_isNull != 'undefined') {
      return __super_isNull.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Alias of {@link RequestParameter#isNull}

   @public

   @return {boolean} 
   */
  this.isEmpty =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isEmpty()"]() ;
    } else if (typeof __super_isEmpty != 'undefined') {
      return __super_isEmpty.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Converts deeply this RequestParameter in a Json representation

   @public

   @return {Object} 
   */
  this.toJson =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedtoJson == null) {
        that.cachedtoJson = utils.convReturnTypeUnknown(j_requestParameter["toJson()"]());
      }
      return that.cachedtoJson;
    } else if (typeof __super_toJson != 'undefined') {
      return __super_toJson.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Merge this request parameter with another one. Note: the parameter passed by argument has the priority

   @public
   @param otherParameter {RequestParameter} 
   @return {RequestParameter} 
   */
  this.merge =  function(otherParameter) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameter["merge(io.vertx.ext.web.api.RequestParameter)"](otherParameter._jdel)) ;
    } else if (typeof __super_merge != 'undefined') {
      return __super_merge.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_requestParameter;
};

RequestParameter._jclass = utils.getJavaClass("io.vertx.ext.web.api.RequestParameter");
RequestParameter._jtype = {accept: function(obj) {
    return RequestParameter._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(RequestParameter.prototype, {});
    RequestParameter.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
RequestParameter._create = function(jdel) {var obj = Object.create(RequestParameter.prototype, {});
  RequestParameter.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-web-api-contract-js/request_parameter
 @param value {Object} 
 @return {RequestParameter}
 */
RequestParameter.create =  function() {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] !== 'function') {
    return utils.convReturnVertxGen(RequestParameter, JRequestParameter["create(java.lang.String,java.lang.Object)"](__args[0], utils.convParamTypeUnknown(__args[1]))) ;
  } else if (__args.length === 1 && typeof __args[0] !== 'function') {
    return utils.convReturnVertxGen(RequestParameter, JRequestParameter["create(java.lang.Object)"](utils.convParamTypeUnknown(__args[0]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = RequestParameter;