/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-js/bridge_event */
var utils = require('vertx-js/util/utils');
var SockJSSocket = require('vertx-web-js/sock_js_socket');
var BaseBridgeEvent = require('vertx-bridge-common-js/base_bridge_event');
var Future = require('vertx-js/future');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JBridgeEvent = Java.type('io.vertx.ext.web.handler.sockjs.BridgeEvent');

/**
 Represents an event that occurs on the event bus bridge.
 <p>
 Please consult the documentation for a full explanation.

 @class
*/
var BridgeEvent = function(j_val) {

  var j_bridgeEvent = j_val;
  var that = this;
  BaseBridgeEvent.call(this, j_val);

  var __super_complete = this.complete;
  var __super_tryComplete = this.tryComplete;
  var __super_future = this.future;
  var __super_setRawMessage = this.setRawMessage;
  var __super_socket = this.socket;
  /**
   Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
   <p/>
   Any handler set on the associated promise will be called.

   @public
   @param result {boolean} the result 
   */
  this.complete =  function(result) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_bridgeEvent["complete(java.lang.Boolean)"](result);
    } else if (typeof __super_complete != 'undefined') {
      return __super_complete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Like {@link Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
   an IllegalStateException, it returns <code>true</code> otherwise.

   @public
   @param result {boolean} the result 
   @return {boolean} <code>false</code> when the future is already completed
   */
  this.tryComplete =  function(result) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_bridgeEvent["tryComplete(java.lang.Boolean)"](result) ;
    } else if (typeof __super_tryComplete != 'undefined') {
      return __super_tryComplete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Future} the  associated with this promise, it can be used to be aware of the promise completion
   */
  this.future =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedfuture == null) {
        that.cachedfuture = utils.convReturnVertxGen(Future, j_bridgeEvent["future()"](), undefined);
      }
      return that.cachedfuture;
    } else if (typeof __super_future != 'undefined') {
      return __super_future.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
   no message involved.

   @public
   @param message {Object} the raw message 
   @return {BridgeEvent} this reference, so it can be used fluently
   */
  this.setRawMessage =  function(message) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_bridgeEvent["setRawMessage(io.vertx.core.json.JsonObject)"](utils.convParamJsonObject(message)) ;
      return that;
    } else if (typeof __super_setRawMessage != 'undefined') {
      return __super_setRawMessage.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the SockJSSocket instance corresponding to the event

   @public

   @return {SockJSSocket} the SockJSSocket instance
   */
  this.socket =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedsocket == null) {
        that.cachedsocket = utils.convReturnVertxGen(SockJSSocket, j_bridgeEvent["socket()"]());
      }
      return that.cachedsocket;
    } else if (typeof __super_socket != 'undefined') {
      return __super_socket.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_bridgeEvent;
};

BridgeEvent._jclass = utils.getJavaClass("io.vertx.ext.web.handler.sockjs.BridgeEvent");
BridgeEvent._jtype = {accept: function(obj) {
    return BridgeEvent._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(BridgeEvent.prototype, {});
    BridgeEvent.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
BridgeEvent._create = function(jdel) {var obj = Object.create(BridgeEvent.prototype, {});
  BridgeEvent.apply(obj, arguments);
  return obj;
}
module.exports = BridgeEvent;