/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-oauth2-js/o_auth2_auth */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');
var OAuth2RBAC = require('vertx-auth-oauth2-js/o_auth2_rbac');
var Future = require('vertx-js/future');
var AccessToken = require('vertx-auth-oauth2-js/access_token');
var AuthProvider = require('vertx-auth-common-js/auth_provider');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JOAuth2Auth = Java.type('io.vertx.ext.auth.oauth2.OAuth2Auth');
var OAuth2ClientOptions = Java.type('io.vertx.ext.auth.oauth2.OAuth2ClientOptions');

/**

 @class
*/
var OAuth2Auth = function(j_val) {

  var j_oAuth2Auth = j_val;
  var that = this;
  AuthProvider.call(this, j_val);

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_authorizeURL = this.authorizeURL;
  var __super_decodeToken = this.decodeToken;
  var __super_introspectToken = this.introspectToken;
  var __super_introspectToken = this.introspectToken;
  var __super_getFlowType = this.getFlowType;
  var __super_loadJWK = this.loadJWK;
  var __super_rbacHandler = this.rbacHandler;
  /**
   Generate a redirect URL to the authN/Z backend. It only applies to auth_code flow.

   @public
   @param params {Object} 
   @return {string}
   */
  this.authorizeURL =  function(params) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_oAuth2Auth["authorizeURL(io.vertx.core.json.JsonObject)"](utils.convParamJsonObject(params)) ;
    } else if (typeof __super_authorizeURL != 'undefined') {
      return __super_authorizeURL.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Decode a token to a {@link AccessToken} object. This is useful to handle bearer JWT tokens.

   @public
   @param token {string} the access token (base64 string) 
   @param handler {function} A handler to receive the event 
   @return {OAuth2Auth} self
   */
  this.decodeToken =  function(token, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_oAuth2Auth["decodeToken(java.lang.String,io.vertx.core.Handler)"](token, function(ar) {
        if (ar.succeeded()) {
          handler(utils.convReturnVertxGen(AccessToken, ar.result()), null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_oAuth2Auth["decodeToken(java.lang.String,io.vertx.core.Handler)"](token, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AccessToken, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_decodeToken != 'undefined') {
      return __super_decodeToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   meta-information about this token.

   @public
   @param token {string} the access token (base64 string) 
   @param tokenType {string} hint to the token type e.g.: `access_token` 
   @param handler {function} A handler to receive the event 
   @return {OAuth2Auth} self
   */
  this.introspectToken =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_oAuth2Auth["introspectToken(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(AccessToken, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_oAuth2Auth["introspectToken(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AccessToken, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_oAuth2Auth["introspectToken(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(AccessToken, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_oAuth2Auth["introspectToken(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AccessToken, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_introspectToken != 'undefined') {
      return __super_introspectToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the configured flow type for the Oauth2 provider.

   @public

   @return {Object} the flow type.
   */
  this.getFlowType =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnEnum(j_oAuth2Auth["getFlowType()"]()) ;
    } else if (typeof __super_getFlowType != 'undefined') {
      return __super_getFlowType.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Loads a JWK Set from the remote provider.

   When calling this method several times, the loaded JWKs are updated in the underlying JWT object.

   @public
   @param handler {function} 
   @return {OAuth2Auth}
   */
  this.loadJWK =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_oAuth2Auth["loadJWK(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_oAuth2Auth["loadJWK(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_loadJWK != 'undefined') {
      return __super_loadJWK.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param rbac {OAuth2RBAC} 
   @return {OAuth2Auth}
   */
  this.rbacHandler =  function(rbac) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_oAuth2Auth["rbacHandler(io.vertx.ext.auth.oauth2.OAuth2RBAC)"](rbac._jdel) ;
      return that;
    } else if (typeof __super_rbacHandler != 'undefined') {
      return __super_rbacHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_oAuth2Auth;
};

OAuth2Auth._jclass = utils.getJavaClass("io.vertx.ext.auth.oauth2.OAuth2Auth");
OAuth2Auth._jtype = {accept: function(obj) {
    return OAuth2Auth._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(OAuth2Auth.prototype, {});
    OAuth2Auth.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
OAuth2Auth._create = function(jdel) {var obj = Object.create(OAuth2Auth.prototype, {});
  OAuth2Auth.apply(obj, arguments);
  return obj;
}
/**
 Create a OAuth2 auth provider

 @memberof module:vertx-auth-oauth2-js/o_auth2_auth
 @param vertx {Vertx} the Vertx instance 
 @param config {Object} the config 
 @return {OAuth2Auth} the auth provider
 */
OAuth2Auth.create =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(OAuth2Auth, JOAuth2Auth["create(io.vertx.core.Vertx)"](__args[0]._jdel)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(OAuth2Auth, JOAuth2Auth["create(io.vertx.core.Vertx,io.vertx.ext.auth.oauth2.OAuth2ClientOptions)"](__args[0]._jdel, __args[1]  != null ? new OAuth2ClientOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = OAuth2Auth;