/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-mail-js/mail_attachment */
var utils = require('vertx-js/util/utils');
var Buffer = require('vertx-js/buffer');
var MultiMap = require('vertx-js/multi_map');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JMailAttachment = Java.type('io.vertx.ext.mail.MailAttachment');

/**
 Represent a mail attachment that can be used in a MailMessage.

 @class
*/
var MailAttachment = function(j_val) {

  var j_mailAttachment = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_create = this.create;
  var __super_getData = this.getData;
  var __super_setData = this.setData;
  var __super_getName = this.getName;
  var __super_setName = this.setName;
  var __super_getContentType = this.getContentType;
  var __super_setContentType = this.setContentType;
  var __super_getDisposition = this.getDisposition;
  var __super_setDisposition = this.setDisposition;
  var __super_getDescription = this.getDescription;
  var __super_setDescription = this.setDescription;
  var __super_getContentId = this.getContentId;
  var __super_setContentId = this.setContentId;
  var __super_addHeader = this.addHeader;
  var __super_getHeaders = this.getHeaders;
  var __super_setHeaders = this.setHeaders;
  var __super_toJson = this.toJson;
  /**
   get the data

   @public

   @return {Buffer} the data
   */
  this.getData =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Buffer, j_mailAttachment["getData()"]()) ;
    } else if (typeof __super_getData != 'undefined') {
      return __super_getData.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   set the data

   @public
   @param data {Buffer} Buffer of bytes to be used at attachment 
   @return {MailAttachment} this to be able to use it fluently
   */
  this.setData =  function(data) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_mailAttachment["setData(io.vertx.core.buffer.Buffer)"](data._jdel) ;
      return that;
    } else if (typeof __super_setData != 'undefined') {
      return __super_setData.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   get the name

   @public

   @return {string} the name
   */
  this.getName =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_mailAttachment["getName()"]() ;
    } else if (typeof __super_getName != 'undefined') {
      return __super_getName.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   set the name

   @public
   @param name {string} name of the attachment file 
   @return {MailAttachment} this to be able to use it fluently <p> name is the descriptive filename that will be put into the mail i.e. usually a local filename without path this can be set to "" to omit the filename attribute
   */
  this.setName =  function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_mailAttachment["setName(java.lang.String)"](name) ;
      return that;
    } else if (typeof __super_setName != 'undefined') {
      return __super_setName.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   get the Content-Type

   @public

   @return {string} the contentType
   */
  this.getContentType =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_mailAttachment["getContentType()"]() ;
    } else if (typeof __super_getContentType != 'undefined') {
      return __super_getContentType.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   set the Content-Type

   @public
   @param contentType {string} the contentType 
   @return {MailAttachment} this to be able to use it fluently
   */
  this.setContentType =  function(contentType) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_mailAttachment["setContentType(java.lang.String)"](contentType) ;
      return that;
    } else if (typeof __super_setContentType != 'undefined') {
      return __super_setContentType.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   get the disposition field

   @public

   @return {string} the disposition
   */
  this.getDisposition =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_mailAttachment["getDisposition()"]() ;
    } else if (typeof __super_getDisposition != 'undefined') {
      return __super_getDisposition.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   set the disposition field to be used in the attachment

   @public
   @param disposition {string} the disposition 
   @return {MailAttachment} this to be able to use it fluently
   */
  this.setDisposition =  function(disposition) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_mailAttachment["setDisposition(java.lang.String)"](disposition) ;
      return that;
    } else if (typeof __super_setDisposition != 'undefined') {
      return __super_setDisposition.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   get the description field

   @public

   @return {string} the description
   */
  this.getDescription =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_mailAttachment["getDescription()"]() ;
    } else if (typeof __super_getDescription != 'undefined') {
      return __super_getDescription.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   set the description field to be used in the attachment

   @public
   @param description {string} the description 
   @return {MailAttachment} this to be able to use it fluently
   */
  this.setDescription =  function(description) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_mailAttachment["setDescription(java.lang.String)"](description) ;
      return that;
    } else if (typeof __super_setDescription != 'undefined') {
      return __super_setDescription.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   get the Content-ID field

   @public

   @return {string} the content id
   */
  this.getContentId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_mailAttachment["getContentId()"]() ;
    } else if (typeof __super_getContentId != 'undefined') {
      return __super_getContentId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   set the Content-ID field to be used in the attachment

   @public
   @param contentId {string} the content id 
   @return {MailAttachment} this to be able to use it fluently
   */
  this.setContentId =  function(contentId) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_mailAttachment["setContentId(java.lang.String)"](contentId) ;
      return that;
    } else if (typeof __super_setContentId != 'undefined') {
      return __super_setContentId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add an header to this attachment.

   @public
   @param key {string} the header key 
   @param value {string} the header value 
   @return {MailAttachment} a reference to this, so the API can be used fluently
   */
  this.addHeader =  function(key, value) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      j_mailAttachment["addHeader(java.lang.String,java.lang.String)"](key, value) ;
      return that;
    } else if (typeof __super_addHeader != 'undefined') {
      return __super_addHeader.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the headers to be added for this attachment.

   @public

   @return {MultiMap} the headers
   */
  this.getHeaders =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(MultiMap, j_mailAttachment["getHeaders()"]()) ;
    } else if (typeof __super_getHeaders != 'undefined') {
      return __super_getHeaders.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set the headers to be added for this attachment.

   @public
   @param headers {MultiMap} the headers to be added 
   @return {MailAttachment} this to be able to use it fluently
   */
  this.setHeaders =  function(headers) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_mailAttachment["setHeaders(io.vertx.core.MultiMap)"](headers._jdel) ;
      return that;
    } else if (typeof __super_setHeaders != 'undefined') {
      return __super_setHeaders.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   convert this object to JSON representation

   @public

   @return {Object} the JSON object
   */
  this.toJson =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_mailAttachment["toJson()"]()) ;
    } else if (typeof __super_toJson != 'undefined') {
      return __super_toJson.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_mailAttachment;
};

MailAttachment._jclass = utils.getJavaClass("io.vertx.ext.mail.MailAttachment");
MailAttachment._jtype = {accept: function(obj) {
    return MailAttachment._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(MailAttachment.prototype, {});
    MailAttachment.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MailAttachment._create = function(jdel) {var obj = Object.create(MailAttachment.prototype, {});
  MailAttachment.apply(obj, arguments);
  return obj;
}
/**
 create a copy of a MailAttachment object

 @memberof module:vertx-mail-js/mail_attachment
 @param other {MailAttachment} object to be copied 
 @return {MailAttachment}
 */
MailAttachment.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(MailAttachment, JMailAttachment["create()"]()) ;
  } else if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
    return utils.convReturnVertxGen(MailAttachment, JMailAttachment["create(io.vertx.core.json.JsonObject)"](utils.convParamJsonObject(__args[0]))) ;
  } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(MailAttachment, JMailAttachment["create(io.vertx.ext.mail.MailAttachment)"](__args[0]._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = MailAttachment;