/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-shell-js/tty */
var utils = require('vertx-js/util/utils');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JTty = Java.type('io.vertx.ext.shell.term.Tty');

/**
 Provide interactions with the Shell TTY.

 @class
*/
var Tty = function(j_val) {

  var j_tty = j_val;
  var that = this;

  var __super_type = this.type;
  var __super_width = this.width;
  var __super_height = this.height;
  var __super_stdinHandler = this.stdinHandler;
  var __super_write = this.write;
  var __super_resizehandler = this.resizehandler;
  /**

   @public

   @return {string} the declared tty type, for instance , , etc... it can be null when the tty does not have declared its type.
   */
  this.type =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_tty["type()"]() ;
    } else if (typeof __super_type != 'undefined') {
      return __super_type.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the current width, i.e the number of rows or  if unknown
   */
  this.width =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_tty["width()"]() ;
    } else if (typeof __super_width != 'undefined') {
      return __super_width.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the current height, i.e the number of columns or  if unknown
   */
  this.height =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_tty["height()"]() ;
    } else if (typeof __super_height != 'undefined') {
      return __super_height.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set a stream handler on the standard input to read the data.

   @public
   @param handler {function} the standard input 
   @return {Tty} this object
   */
  this.stdinHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_tty["stdinHandler(io.vertx.core.Handler)"](function(jVal) {
        handler(jVal);
      }) ;
      return that;
    } else if (typeof __super_stdinHandler != 'undefined') {
      return __super_stdinHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Write data to the standard output.

   @public
   @param data {string} the data to write 
   @return {Tty} this object
   */
  this.write =  function(data) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_tty["write(java.lang.String)"](data) ;
      return that;
    } else if (typeof __super_write != 'undefined') {
      return __super_write.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set a resize handler, the handler is called when the tty size changes.

   @public
   @param handler {function} the resize handler 
   @return {Tty} this object
   */
  this.resizehandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_tty["resizehandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_resizehandler != 'undefined') {
      return __super_resizehandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_tty;
};

Tty._jclass = utils.getJavaClass("io.vertx.ext.shell.term.Tty");
Tty._jtype = {accept: function(obj) {
    return Tty._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Tty.prototype, {});
    Tty.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Tty._create = function(jdel) {var obj = Object.create(Tty.prototype, {});
  Tty.apply(obj, arguments);
  return obj;
}
module.exports = Tty;