/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-unit-js/async */
var utils = require('vertx-js/util/utils');
var Completion = require('vertx-unit-js/completion');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAsync = Java.type('io.vertx.ext.unit.Async');

/**
 An asynchronous exit point for a test.<p/>

 @class
*/
var Async = function(j_val) {

  var j_async = j_val;
  var that = this;
  Completion.call(this, j_val, undefined);

  var __super_resolve = this.resolve;
  var __super_handler = this.handler;
  var __super_count = this.count;
  var __super_countDown = this.countDown;
  var __super_complete = this.complete;
  /**
   Completes the future upon completion, otherwise fails it.

   @public
   @param future {Promise} the future to resolve 
   */
  this.resolve =  function(future) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_async["resolve(io.vertx.core.Promise)"](future._jdel);
    } else if (typeof __super_resolve != 'undefined') {
      return __super_resolve.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Completion handler to receive a completion signal when this completions completes.

   @public
   @param completionHandler {function} the completion handler 
   */
  this.handler =  function(completionHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_async["handler(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          completionHandler(null, null);
        } else {
          completionHandler(null, ar.cause());
        }
      });
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_async["handler(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_handler != 'undefined') {
      return __super_handler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the current count
   */
  this.count =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_async["count()"]() ;
    } else if (typeof __super_count != 'undefined') {
      return __super_count.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Count down the async.

   @public

   */
  this.countDown =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_async["countDown()"]();
    } else if (typeof __super_countDown != 'undefined') {
      return __super_countDown.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Signals the asynchronous operation is done, this method must be called with a count greater than <code>0</code>,
   otherwise it throws an <code>IllegalStateException</code> to signal the error.

   @public

   */
  this.complete =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_async["complete()"]();
    } else if (typeof __super_complete != 'undefined') {
      return __super_complete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_async;
};

Async._jclass = utils.getJavaClass("io.vertx.ext.unit.Async");
Async._jtype = {accept: function(obj) {
    return Async._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Async.prototype, {});
    Async.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Async._create = function(jdel) {var obj = Object.create(Async.prototype, {});
  Async.apply(obj, arguments);
  return obj;
}
module.exports = Async;