/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-js/router */
var utils = require('vertx-js/util/utils');
var Route = require('vertx-web-js/route');
var HttpServerRequest = require('vertx-js/http_server_request');
var Vertx = require('vertx-js/vertx');
var RoutingContext = require('vertx-web-js/routing_context');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JRouter = Java.type('io.vertx.ext.web.Router');

/**

 @class
*/
var Router = function(j_val) {

  var j_router = j_val;
  var that = this;

  var __super_handle = this.handle;
  var __super_router = this.router;
  var __super_route = this.route;
  var __super_route = this.route;
  var __super_route = this.route;
  var __super_routeWithRegex = this.routeWithRegex;
  var __super_routeWithRegex = this.routeWithRegex;
  var __super_get = this.get;
  var __super_get = this.get;
  var __super_getWithRegex = this.getWithRegex;
  var __super_head = this.head;
  var __super_head = this.head;
  var __super_headWithRegex = this.headWithRegex;
  var __super_options = this.options;
  var __super_options = this.options;
  var __super_optionsWithRegex = this.optionsWithRegex;
  var __super_put = this.put;
  var __super_put = this.put;
  var __super_putWithRegex = this.putWithRegex;
  var __super_post = this.post;
  var __super_post = this.post;
  var __super_postWithRegex = this.postWithRegex;
  var __super_delete = this.delete;
  var __super_delete = this.delete;
  var __super_deleteWithRegex = this.deleteWithRegex;
  var __super_trace = this.trace;
  var __super_trace = this.trace;
  var __super_traceWithRegex = this.traceWithRegex;
  var __super_connect = this.connect;
  var __super_connect = this.connect;
  var __super_connectWithRegex = this.connectWithRegex;
  var __super_patch = this.patch;
  var __super_patch = this.patch;
  var __super_patchWithRegex = this.patchWithRegex;
  var __super_getRoutes = this.getRoutes;
  var __super_clear = this.clear;
  var __super_mountSubRouter = this.mountSubRouter;
  var __super_exceptionHandler = this.exceptionHandler;
  var __super_errorHandler = this.errorHandler;
  var __super_handleContext = this.handleContext;
  var __super_handleFailure = this.handleFailure;
  var __super_modifiedHandler = this.modifiedHandler;
  /**
   Something has happened, so handle it.

   @public
   @param event {HttpServerRequest} the event to handle 
   */
  this.handle =  function(event) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_router["handle(io.vertx.core.http.HttpServerRequest)"](event._jdel);
    } else if (typeof __super_handle != 'undefined') {
      return __super_handle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches the specified path

   @public
   @param path {string} URI paths that begin with this path will match 
   @return {Route} the route
   */
  this.route =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Route, j_router["route()"]()) ;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["route(io.vertx.core.http.HttpMethod,java.lang.String)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1])) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["route(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_route != 'undefined') {
      return __super_route.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches the specified path regex

   @public
   @param regex {string} URI paths that begin with a match for this regex will match 
   @return {Route} the route
   */
  this.routeWithRegex =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["routeWithRegex(io.vertx.core.http.HttpMethod,java.lang.String)"](io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1])) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["routeWithRegex(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_routeWithRegex != 'undefined') {
      return __super_routeWithRegex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP GET request and the specified path

   @public
   @param path {string} URI paths that begin with this path will match 
   @return {Route} the route
   */
  this.get =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Route, j_router["get()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["get(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_get != 'undefined') {
      return __super_get.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP GET request and the specified path regex

   @public
   @param regex {string} URI paths that begin with a match for this regex will match 
   @return {Route} the route
   */
  this.getWithRegex =  function(regex) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["getWithRegex(java.lang.String)"](regex)) ;
    } else if (typeof __super_getWithRegex != 'undefined') {
      return __super_getWithRegex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP HEAD request and the specified path

   @public
   @param path {string} URI paths that begin with this path will match 
   @return {Route} the route
   */
  this.head =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Route, j_router["head()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["head(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_head != 'undefined') {
      return __super_head.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP HEAD request and the specified path regex

   @public
   @param regex {string} URI paths that begin with a match for this regex will match 
   @return {Route} the route
   */
  this.headWithRegex =  function(regex) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["headWithRegex(java.lang.String)"](regex)) ;
    } else if (typeof __super_headWithRegex != 'undefined') {
      return __super_headWithRegex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP OPTIONS request and the specified path

   @public
   @param path {string} URI paths that begin with this path will match 
   @return {Route} the route
   */
  this.options =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Route, j_router["options()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["options(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_options != 'undefined') {
      return __super_options.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP OPTIONS request and the specified path regex

   @public
   @param regex {string} URI paths that begin with a match for this regex will match 
   @return {Route} the route
   */
  this.optionsWithRegex =  function(regex) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["optionsWithRegex(java.lang.String)"](regex)) ;
    } else if (typeof __super_optionsWithRegex != 'undefined') {
      return __super_optionsWithRegex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP PUT request and the specified path

   @public
   @param path {string} URI paths that begin with this path will match 
   @return {Route} the route
   */
  this.put =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Route, j_router["put()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["put(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_put != 'undefined') {
      return __super_put.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP PUT request and the specified path regex

   @public
   @param regex {string} URI paths that begin with a match for this regex will match 
   @return {Route} the route
   */
  this.putWithRegex =  function(regex) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["putWithRegex(java.lang.String)"](regex)) ;
    } else if (typeof __super_putWithRegex != 'undefined') {
      return __super_putWithRegex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP POST request and the specified path

   @public
   @param path {string} URI paths that begin with this path will match 
   @return {Route} the route
   */
  this.post =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Route, j_router["post()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["post(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_post != 'undefined') {
      return __super_post.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP POST request and the specified path regex

   @public
   @param regex {string} URI paths that begin with a match for this regex will match 
   @return {Route} the route
   */
  this.postWithRegex =  function(regex) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["postWithRegex(java.lang.String)"](regex)) ;
    } else if (typeof __super_postWithRegex != 'undefined') {
      return __super_postWithRegex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP DELETE request and the specified path

   @public
   @param path {string} URI paths that begin with this path will match 
   @return {Route} the route
   */
  this.delete =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Route, j_router["delete()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["delete(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_delete != 'undefined') {
      return __super_delete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP DELETE request and the specified path regex

   @public
   @param regex {string} URI paths that begin with a match for this regex will match 
   @return {Route} the route
   */
  this.deleteWithRegex =  function(regex) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["deleteWithRegex(java.lang.String)"](regex)) ;
    } else if (typeof __super_deleteWithRegex != 'undefined') {
      return __super_deleteWithRegex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP TRACE request and the specified path

   @public
   @param path {string} URI paths that begin with this path will match 
   @return {Route} the route
   */
  this.trace =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Route, j_router["trace()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["trace(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_trace != 'undefined') {
      return __super_trace.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP TRACE request and the specified path regex

   @public
   @param regex {string} URI paths that begin with a match for this regex will match 
   @return {Route} the route
   */
  this.traceWithRegex =  function(regex) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["traceWithRegex(java.lang.String)"](regex)) ;
    } else if (typeof __super_traceWithRegex != 'undefined') {
      return __super_traceWithRegex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP CONNECT request and the specified path

   @public
   @param path {string} URI paths that begin with this path will match 
   @return {Route} the route
   */
  this.connect =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Route, j_router["connect()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["connect(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_connect != 'undefined') {
      return __super_connect.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP CONNECT request and the specified path regex

   @public
   @param regex {string} URI paths that begin with a match for this regex will match 
   @return {Route} the route
   */
  this.connectWithRegex =  function(regex) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["connectWithRegex(java.lang.String)"](regex)) ;
    } else if (typeof __super_connectWithRegex != 'undefined') {
      return __super_connectWithRegex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP PATCH request and the specified path

   @public
   @param path {string} URI paths that begin with this path will match 
   @return {Route} the route
   */
  this.patch =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Route, j_router["patch()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["patch(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_patch != 'undefined') {
      return __super_patch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a route that matches a HTTP PATCH request and the specified path regex

   @public
   @param regex {string} URI paths that begin with a match for this regex will match 
   @return {Route} the route
   */
  this.patchWithRegex =  function(regex) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Route, j_router["patchWithRegex(java.lang.String)"](regex)) ;
    } else if (typeof __super_patchWithRegex != 'undefined') {
      return __super_patchWithRegex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Route>} a list of all the routes on this router
   */
  this.getRoutes =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetVertxGen(j_router["getRoutes()"](), Route) ;
    } else if (typeof __super_getRoutes != 'undefined') {
      return __super_getRoutes.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Remove all the routes from this router

   @public

   @return {Router} a reference to this, so the API can be used fluently
   */
  this.clear =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_router["clear()"]() ;
      return that;
    } else if (typeof __super_clear != 'undefined') {
      return __super_clear.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Mount a sub router on this router

   @public
   @param mountPoint {string} the mount point (path prefix) to mount it on 
   @param subRouter {Router} the router to mount as a sub router 
   @return {Router} a reference to this, so the API can be used fluently
   */
  this.mountSubRouter =  function(mountPoint, subRouter) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel) {
      j_router["mountSubRouter(java.lang.String,io.vertx.ext.web.Router)"](mountPoint, subRouter._jdel) ;
      return that;
    } else if (typeof __super_mountSubRouter != 'undefined') {
      return __super_mountSubRouter.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Specify a handler for any unhandled exceptions on this router. The handler will be called for exceptions thrown
   from handlers. This does not affect the normal failure routing logic.

   @public
   @param exceptionHandler {function} the exception handler 
   @return {Router} a reference to this, so the API can be used fluently
   */
  this.exceptionHandler =  function(exceptionHandler) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'function' || __args[0] == null)) {
      j_router["exceptionHandler(io.vertx.core.Handler)"](exceptionHandler == null ? null : function(jVal) {
        exceptionHandler(utils.convReturnThrowable(jVal));
      }) ;
      return that;
    } else if (typeof __super_exceptionHandler != 'undefined') {
      return __super_exceptionHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Specify an handler to handle an error for a particular status code. You can use to manage general errors too using status code 500.
   The handler will be called when the context fails and other failure handlers didn't write the reply or when an exception is thrown inside an handler.
   You <b>must not</b> use {@link RoutingContext#next} inside the error handler
   This does not affect the normal failure routing logic.

   @public
   @param statusCode {number} status code the errorHandler is capable of handle 
   @param errorHandler {function} error handler. Note: You <b>must not</b> use {@link RoutingContext#next} inside the provided handler 
   @return {Router} a reference to this, so the API can be used fluently
   */
  this.errorHandler =  function(statusCode, errorHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='number' && typeof __args[1] === 'function') {
      j_router["errorHandler(int,io.vertx.core.Handler)"](statusCode, function(jVal) {
        errorHandler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_errorHandler != 'undefined') {
      return __super_errorHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Used to route a context to the router. Used for sub-routers. You wouldn't normally call this method directly.

   @public
   @param context {RoutingContext} the routing context 
   */
  this.handleContext =  function(context) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_router["handleContext(io.vertx.ext.web.RoutingContext)"](context._jdel);
    } else if (typeof __super_handleContext != 'undefined') {
      return __super_handleContext.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Used to route a failure to the router. Used for sub-routers. You wouldn't normally call this method directly.

   @public
   @param context {RoutingContext} the routing context 
   */
  this.handleFailure =  function(context) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_router["handleFailure(io.vertx.ext.web.RoutingContext)"](context._jdel);
    } else if (typeof __super_handleFailure != 'undefined') {
      return __super_handleFailure.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   When a Router routes are changed this handler is notified.
   This is useful for routes that depend on the state of the router.

   @public
   @param handler {function} a notification handler that will receive this router as argument 
   @return {Router} a reference to this, so the API can be used fluently
   */
  this.modifiedHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_router["modifiedHandler(io.vertx.core.Handler)"](function(jVal) {
        handler(utils.convReturnVertxGen(Router, jVal));
      }) ;
      return that;
    } else if (typeof __super_modifiedHandler != 'undefined') {
      return __super_modifiedHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_router;
};

Router._jclass = utils.getJavaClass("io.vertx.ext.web.Router");
Router._jtype = {accept: function(obj) {
    return Router._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Router.prototype, {});
    Router.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Router._create = function(jdel) {var obj = Object.create(Router.prototype, {});
  Router.apply(obj, arguments);
  return obj;
}
/**
 Create a router

 @memberof module:vertx-web-js/router
 @param vertx {Vertx} the Vert.x instance 
 @return {Router} the router
 */
Router.router =  function(vertx) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(Router, JRouter["router(io.vertx.core.Vertx)"](vertx._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = Router;