/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-templ-rocker-js/rocker_template_engine */
var utils = require('vertx-js/util/utils');
var TemplateEngine = require('vertx-web-common-js/template_engine');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JRockerTemplateEngine = Java.type('io.vertx.ext.web.templ.rocker.RockerTemplateEngine');

/**
 A template engine that uses the Rocker library.

 @class
*/
var RockerTemplateEngine = function(j_val) {

  var j_rockerTemplateEngine = j_val;
  var that = this;
  TemplateEngine.call(this, j_val);

  var __super_create = this.create;
  var __super_create = this.create;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_rockerTemplateEngine;
};

RockerTemplateEngine._jclass = utils.getJavaClass("io.vertx.ext.web.templ.rocker.RockerTemplateEngine");
RockerTemplateEngine._jtype = {accept: function(obj) {
    return RockerTemplateEngine._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(RockerTemplateEngine.prototype, {});
    RockerTemplateEngine.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
RockerTemplateEngine._create = function(jdel) {var obj = Object.create(RockerTemplateEngine.prototype, {});
  RockerTemplateEngine.apply(obj, arguments);
  return obj;
}
/**
 Create a template engine using a custom extension

 @memberof module:vertx-web-templ-rocker-js/rocker_template_engine
 @param extension {string} 
 @return {RockerTemplateEngine} the engine
 */
RockerTemplateEngine.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(RockerTemplateEngine, JRockerTemplateEngine["create()"]()) ;
  } else if (__args.length === 1 && typeof __args[0] === 'string') {
    return utils.convReturnVertxGen(RockerTemplateEngine, JRockerTemplateEngine["create(java.lang.String)"](__args[0])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

RockerTemplateEngine.DEFAULT_TEMPLATE_EXTENSION = JRockerTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;
module.exports = RockerTemplateEngine;