/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-js/srv_record */
var utils = require('vertx-js/util/utils');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JSrvRecord = Java.type('io.vertx.core.dns.SrvRecord');

/**
 Represent a Service-Record (SRV) which was resolved for a domain.

 @class
*/
var SrvRecord = function(j_val) {

  var j_srvRecord = j_val;
  var that = this;

  var __super_priority = this.priority;
  var __super_weight = this.weight;
  var __super_port = this.port;
  var __super_name = this.name;
  var __super_protocol = this.protocol;
  var __super_service = this.service;
  var __super_target = this.target;
  /**
   Returns the priority for this service record.

   @public

   @return {number}
   */
  this.priority =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_srvRecord["priority()"]() ;
    } else if (typeof __super_priority != 'undefined') {
      return __super_priority.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the weight of this service record.

   @public

   @return {number}
   */
  this.weight =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_srvRecord["weight()"]() ;
    } else if (typeof __super_weight != 'undefined') {
      return __super_weight.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the port the service is running on.

   @public

   @return {number}
   */
  this.port =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_srvRecord["port()"]() ;
    } else if (typeof __super_port != 'undefined') {
      return __super_port.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the name for the server being queried.

   @public

   @return {string}
   */
  this.name =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_srvRecord["name()"]() ;
    } else if (typeof __super_name != 'undefined') {
      return __super_name.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the protocol for the service being queried (i.e. "_tcp").

   @public

   @return {string}
   */
  this.protocol =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_srvRecord["protocol()"]() ;
    } else if (typeof __super_protocol != 'undefined') {
      return __super_protocol.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the service's name (i.e. "_http").

   @public

   @return {string}
   */
  this.service =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_srvRecord["service()"]() ;
    } else if (typeof __super_service != 'undefined') {
      return __super_service.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the name of the host for the service.

   @public

   @return {string}
   */
  this.target =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_srvRecord["target()"]() ;
    } else if (typeof __super_target != 'undefined') {
      return __super_target.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_srvRecord;
};

SrvRecord._jclass = utils.getJavaClass("io.vertx.core.dns.SrvRecord");
SrvRecord._jtype = {accept: function(obj) {
    return SrvRecord._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(SrvRecord.prototype, {});
    SrvRecord.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
SrvRecord._create = function(jdel) {var obj = Object.create(SrvRecord.prototype, {});
  SrvRecord.apply(obj, arguments);
  return obj;
}
module.exports = SrvRecord;