/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-pg-client-js/pg_connection */
var utils = require('vertx-js/util/utils');
var SqlConnection = require('vertx-sql-client-js/sql_connection');
var Vertx = require('vertx-js/vertx');
var Row = require('vertx-sql-client-js/row');
var RowSet = require('vertx-sql-client-js/row_set');
var PreparedQuery = require('vertx-sql-client-js/prepared_query');
var Tuple = require('vertx-sql-client-js/tuple');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JPgConnection = Java.type('io.vertx.pgclient.PgConnection');
var PgNotification = Java.type('io.vertx.pgclient.PgNotification');
var PgConnectOptions = Java.type('io.vertx.pgclient.PgConnectOptions');

/**
 A connection to Postgres.

 @class
*/
var PgConnection = function(j_val) {

  var j_pgConnection = j_val;
  var that = this;
  SqlConnection.call(this, j_val);

  var __super_connect = this.connect;
  var __super_connect = this.connect;
  var __super_connect = this.connect;
  var __super_notificationHandler = this.notificationHandler;
  var __super_cancelRequest = this.cancelRequest;
  var __super_processId = this.processId;
  var __super_secretKey = this.secretKey;
  var __super_prepare = this.prepare;
  var __super_exceptionHandler = this.exceptionHandler;
  var __super_closeHandler = this.closeHandler;
  var __super_preparedQuery = this.preparedQuery;
  var __super_query = this.query;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedBatch = this.preparedBatch;
  /**
   Set an handler called when the connection receives notification on a channel.
   <p/>
   The handler is called with the <a href="../../dataobjects.html#PgNotification">PgNotification</a> and has access to the channel name
   and the notification payload.

   @public
   @param handler {function} the handler 
   @return {PgConnection} the transaction instance
   */
  this.notificationHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgConnection["notificationHandler(io.vertx.core.Handler)"](function(jVal) {
        handler(utils.convReturnDataObjectAnnotated(jVal));
      }) ;
      return that;
    } else if (typeof __super_notificationHandler != 'undefined') {
      return __super_notificationHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a request cancellation message to tell the server to cancel processing request in this connection.
   <br>Note: Use this with caution because the cancellation signal may or may not have any effect.

   @public
   @param handler {function} the handler notified if cancelling request is sent 
   @return {PgConnection} a reference to this, so the API can be used fluently
   */
  this.cancelRequest =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnVertxGen(PgConnection, j_pgConnection["cancelRequest(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      })) ;
    } else if (typeof __super_cancelRequest != 'undefined') {
      return __super_cancelRequest.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} The process ID of the target backend
   */
  this.processId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_pgConnection["processId()"]() ;
    } else if (typeof __super_processId != 'undefined') {
      return __super_processId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} The secret key for the target backend
   */
  this.secretKey =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_pgConnection["secretKey()"]() ;
    } else if (typeof __super_secretKey != 'undefined') {
      return __super_secretKey.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param handler {function} 
   @return {PgConnection}
   */
  this.prepare =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgConnection["prepare(java.lang.String,io.vertx.core.Handler)"](sql, function(ar) {
        if (ar.succeeded()) {
          handler(utils.convReturnVertxGen(PreparedQuery, ar.result()), null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_pgConnection["prepare(java.lang.String,io.vertx.core.Handler)"](sql, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(PreparedQuery, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_prepare != 'undefined') {
      return __super_prepare.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {PgConnection}
   */
  this.exceptionHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgConnection["exceptionHandler(io.vertx.core.Handler)"](function(jVal) {
        handler(utils.convReturnThrowable(jVal));
      }) ;
      return that;
    } else if (typeof __super_exceptionHandler != 'undefined') {
      return __super_exceptionHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {PgConnection}
   */
  this.closeHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgConnection["closeHandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_closeHandler != 'undefined') {
      return __super_closeHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param arguments {Tuple} 
   @param handler {function} 
   @return {PgConnection}
   */
  this.preparedQuery =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgConnection["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_pgConnection["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'function') {
      j_pgConnection["preparedQuery(java.lang.String,io.vertx.sqlclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_pgConnection["preparedQuery(java.lang.String,io.vertx.sqlclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_preparedQuery != 'undefined') {
      return __super_preparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param handler {function} 
   @return {PgConnection}
   */
  this.query =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgConnection["query(java.lang.String,io.vertx.core.Handler)"](sql, function(ar) {
        if (ar.succeeded()) {
          handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_pgConnection["query(java.lang.String,io.vertx.core.Handler)"](sql, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param batch {Array.<Tuple>} 
   @param handler {function} 
   @return {PgConnection}
   */
  this.preparedBatch =  function(sql, batch, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'function') {
      j_pgConnection["preparedBatch(java.lang.String,java.util.List,io.vertx.core.Handler)"](sql, utils.convParamListVertxGen(batch), function(ar) {
        if (ar.succeeded()) {
          handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_pgConnection["preparedBatch(java.lang.String,java.util.List,io.vertx.core.Handler)"](sql, utils.convParamListVertxGen(batch), function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_preparedBatch != 'undefined') {
      return __super_preparedBatch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pgConnection;
};

PgConnection._jclass = utils.getJavaClass("io.vertx.pgclient.PgConnection");
PgConnection._jtype = {accept: function(obj) {
    return PgConnection._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PgConnection.prototype, {});
    PgConnection.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PgConnection._create = function(jdel) {var obj = Object.create(PgConnection.prototype, {});
  PgConnection.apply(obj, arguments);
  return obj;
}
/**
 Like {@link PgConnection#connect} with options build from <code>connectionUri</code>.

 @memberof module:vertx-pg-client-js/pg_connection
 @param vertx {Vertx} 
 @param connectionUri {string} 
 @param handler {function} 
 */
PgConnection.connect =  function() {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
    JPgConnection["connect(io.vertx.core.Vertx,io.vertx.pgclient.PgConnectOptions,io.vertx.core.Handler)"](__args[0]._jdel, __args[1]  != null ? new PgConnectOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
      if (ar.succeeded()) {
        __args[2](utils.convReturnVertxGen(PgConnection, ar.result()), null);
      } else {
        __args[2](null, ar.cause());
      }
    });
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    var __prom = Promise.promise();
    var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
    JPgConnection["connect(io.vertx.core.Vertx,io.vertx.pgclient.PgConnectOptions,io.vertx.core.Handler)"](__args[0]._jdel, __args[1]  != null ? new PgConnectOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
      if (ar.succeeded()) {
        __prom_completer_handler(utils.convReturnVertxGen(PgConnection, ar.result()), null);
      } else {
        __prom_completer_handler(null, ar.cause());
      }
    });
    return __prom.future();
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'function') {
    JPgConnection["connect(io.vertx.core.Vertx,io.vertx.core.Handler)"](__args[0]._jdel, function(ar) {
      if (ar.succeeded()) {
        __args[1](utils.convReturnVertxGen(PgConnection, ar.result()), null);
      } else {
        __args[1](null, ar.cause());
      }
    });
  } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    var __prom = Promise.promise();
    var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
    JPgConnection["connect(io.vertx.core.Vertx,io.vertx.core.Handler)"](__args[0]._jdel, function(ar) {
      if (ar.succeeded()) {
        __prom_completer_handler(utils.convReturnVertxGen(PgConnection, ar.result()), null);
      } else {
        __prom_completer_handler(null, ar.cause());
      }
    });
    return __prom.future();
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
    JPgConnection["connect(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](__args[0]._jdel, __args[1], function(ar) {
      if (ar.succeeded()) {
        __args[2](utils.convReturnVertxGen(PgConnection, ar.result()), null);
      } else {
        __args[2](null, ar.cause());
      }
    });
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string') {
    var __prom = Promise.promise();
    var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
    JPgConnection["connect(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](__args[0]._jdel, __args[1], function(ar) {
      if (ar.succeeded()) {
        __prom_completer_handler(utils.convReturnVertxGen(PgConnection, ar.result()), null);
      } else {
        __prom_completer_handler(null, ar.cause());
      }
    });
    return __prom.future();
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = PgConnection;