/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-redis-js/command */
var utils = require('vertx-js/util/utils');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JCommand = Java.type('io.vertx.redis.client.Command');

/**
 <b>Auto generated</b> API Commands to interact with REDIS.

 @class
*/
var Command = function(j_val) {

  var j_command = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_getArity = this.getArity;
  var __super_isMultiKey = this.isMultiKey;
  var __super_getFirstKey = this.getFirstKey;
  var __super_getLastKey = this.getLastKey;
  var __super_getInterval = this.getInterval;
  var __super_isKeyless = this.isKeyless;
  var __super_isReadOnly = this.isReadOnly;
  var __super_isMovable = this.isMovable;
  /**

   @public

   @return {number}
   */
  this.getArity =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_command["getArity()"]() ;
    } else if (typeof __super_getArity != 'undefined') {
      return __super_getArity.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean}
   */
  this.isMultiKey =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_command["isMultiKey()"]() ;
    } else if (typeof __super_isMultiKey != 'undefined') {
      return __super_isMultiKey.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number}
   */
  this.getFirstKey =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_command["getFirstKey()"]() ;
    } else if (typeof __super_getFirstKey != 'undefined') {
      return __super_getFirstKey.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number}
   */
  this.getLastKey =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_command["getLastKey()"]() ;
    } else if (typeof __super_getLastKey != 'undefined') {
      return __super_getLastKey.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number}
   */
  this.getInterval =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_command["getInterval()"]() ;
    } else if (typeof __super_getInterval != 'undefined') {
      return __super_getInterval.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean}
   */
  this.isKeyless =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_command["isKeyless()"]() ;
    } else if (typeof __super_isKeyless != 'undefined') {
      return __super_isKeyless.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean}
   */
  this.isReadOnly =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_command["isReadOnly()"]() ;
    } else if (typeof __super_isReadOnly != 'undefined') {
      return __super_isReadOnly.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean}
   */
  this.isMovable =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_command["isMovable()"]() ;
    } else if (typeof __super_isMovable != 'undefined') {
      return __super_isMovable.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_command;
};

Command._jclass = utils.getJavaClass("io.vertx.redis.client.Command");
Command._jtype = {accept: function(obj) {
    return Command._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Command.prototype, {});
    Command.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Command._create = function(jdel) {var obj = Object.create(Command.prototype, {});
  Command.apply(obj, arguments);
  return obj;
}
/**
 Creates a Redis Command from METADATA. The metadata comes from the REDIS command "COMMAND"
 https://redis.io/commands/command

 Each top-level result contains six nested results. Each nested result is:

     command name
     command arity specification
     nested Array reply of command flags
     position of first key in argument list
     position of last key in argument list
     step count for locating repeating keys

 @memberof module:vertx-redis-js/command
 @param command {string} command name 
 @param arity {number} arity 
 @param firstKey {number} position of the first key 
 @param lastKey {number} position of the last key 
 @param interval {number} step count for locating repeating keys 
 @param readOnly {boolean} readOnly flag extracted from the nested Array reply of command flags 
 @param movable {boolean} movable flag extracted from the nested Array reply of command flags 
 @return {Command} a command instance
 */
Command.create =  function(command, arity, firstKey, lastKey, interval, readOnly, movable) {
  var __args = arguments;
  if (__args.length === 7 && typeof __args[0] === 'string' && typeof __args[1] ==='number' && typeof __args[2] ==='number' && typeof __args[3] ==='number' && typeof __args[4] ==='number' && typeof __args[5] ==='boolean' && typeof __args[6] ==='boolean') {
    return utils.convReturnVertxGen(Command, JCommand["create(java.lang.String,int,int,int,int,boolean,boolean)"](command, arity, firstKey, lastKey, interval, readOnly, movable)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

Command.APPEND = utils.convReturnVertxGen(Command, JCommand.APPEND);
Command.ASKING = utils.convReturnVertxGen(Command, JCommand.ASKING);
Command.AUTH = utils.convReturnVertxGen(Command, JCommand.AUTH);
Command.BGREWRITEAOF = utils.convReturnVertxGen(Command, JCommand.BGREWRITEAOF);
Command.BGSAVE = utils.convReturnVertxGen(Command, JCommand.BGSAVE);
Command.BITCOUNT = utils.convReturnVertxGen(Command, JCommand.BITCOUNT);
Command.BITFIELD = utils.convReturnVertxGen(Command, JCommand.BITFIELD);
Command.BITOP = utils.convReturnVertxGen(Command, JCommand.BITOP);
Command.BITPOS = utils.convReturnVertxGen(Command, JCommand.BITPOS);
Command.BLPOP = utils.convReturnVertxGen(Command, JCommand.BLPOP);
Command.BRPOP = utils.convReturnVertxGen(Command, JCommand.BRPOP);
Command.BRPOPLPUSH = utils.convReturnVertxGen(Command, JCommand.BRPOPLPUSH);
Command.BZPOPMAX = utils.convReturnVertxGen(Command, JCommand.BZPOPMAX);
Command.BZPOPMIN = utils.convReturnVertxGen(Command, JCommand.BZPOPMIN);
Command.CLIENT = utils.convReturnVertxGen(Command, JCommand.CLIENT);
Command.CLUSTER = utils.convReturnVertxGen(Command, JCommand.CLUSTER);
Command.COMMAND = utils.convReturnVertxGen(Command, JCommand.COMMAND);
Command.CONFIG = utils.convReturnVertxGen(Command, JCommand.CONFIG);
Command.DBSIZE = utils.convReturnVertxGen(Command, JCommand.DBSIZE);
Command.DEBUG = utils.convReturnVertxGen(Command, JCommand.DEBUG);
Command.DECR = utils.convReturnVertxGen(Command, JCommand.DECR);
Command.DECRBY = utils.convReturnVertxGen(Command, JCommand.DECRBY);
Command.DEL = utils.convReturnVertxGen(Command, JCommand.DEL);
Command.DISCARD = utils.convReturnVertxGen(Command, JCommand.DISCARD);
Command.DUMP = utils.convReturnVertxGen(Command, JCommand.DUMP);
Command.ECHO = utils.convReturnVertxGen(Command, JCommand.ECHO);
Command.EVAL = utils.convReturnVertxGen(Command, JCommand.EVAL);
Command.EVALSHA = utils.convReturnVertxGen(Command, JCommand.EVALSHA);
Command.EXEC = utils.convReturnVertxGen(Command, JCommand.EXEC);
Command.EXISTS = utils.convReturnVertxGen(Command, JCommand.EXISTS);
Command.EXPIRE = utils.convReturnVertxGen(Command, JCommand.EXPIRE);
Command.EXPIREAT = utils.convReturnVertxGen(Command, JCommand.EXPIREAT);
Command.FLUSHALL = utils.convReturnVertxGen(Command, JCommand.FLUSHALL);
Command.FLUSHDB = utils.convReturnVertxGen(Command, JCommand.FLUSHDB);
Command.GEOADD = utils.convReturnVertxGen(Command, JCommand.GEOADD);
Command.GEODIST = utils.convReturnVertxGen(Command, JCommand.GEODIST);
Command.GEOHASH = utils.convReturnVertxGen(Command, JCommand.GEOHASH);
Command.GEOPOS = utils.convReturnVertxGen(Command, JCommand.GEOPOS);
Command.GEORADIUS = utils.convReturnVertxGen(Command, JCommand.GEORADIUS);
Command.GEORADIUS_RO = utils.convReturnVertxGen(Command, JCommand.GEORADIUS_RO);
Command.GEORADIUSBYMEMBER = utils.convReturnVertxGen(Command, JCommand.GEORADIUSBYMEMBER);
Command.GEORADIUSBYMEMBER_RO = utils.convReturnVertxGen(Command, JCommand.GEORADIUSBYMEMBER_RO);
Command.GET = utils.convReturnVertxGen(Command, JCommand.GET);
Command.GETBIT = utils.convReturnVertxGen(Command, JCommand.GETBIT);
Command.GETRANGE = utils.convReturnVertxGen(Command, JCommand.GETRANGE);
Command.GETSET = utils.convReturnVertxGen(Command, JCommand.GETSET);
Command.HDEL = utils.convReturnVertxGen(Command, JCommand.HDEL);
Command.HEXISTS = utils.convReturnVertxGen(Command, JCommand.HEXISTS);
Command.HGET = utils.convReturnVertxGen(Command, JCommand.HGET);
Command.HGETALL = utils.convReturnVertxGen(Command, JCommand.HGETALL);
Command.HINCRBY = utils.convReturnVertxGen(Command, JCommand.HINCRBY);
Command.HINCRBYFLOAT = utils.convReturnVertxGen(Command, JCommand.HINCRBYFLOAT);
Command.HKEYS = utils.convReturnVertxGen(Command, JCommand.HKEYS);
Command.HLEN = utils.convReturnVertxGen(Command, JCommand.HLEN);
Command.HMGET = utils.convReturnVertxGen(Command, JCommand.HMGET);
Command.HMSET = utils.convReturnVertxGen(Command, JCommand.HMSET);
Command.HOST = utils.convReturnVertxGen(Command, JCommand.HOST);
Command.HSCAN = utils.convReturnVertxGen(Command, JCommand.HSCAN);
Command.HSET = utils.convReturnVertxGen(Command, JCommand.HSET);
Command.HSETNX = utils.convReturnVertxGen(Command, JCommand.HSETNX);
Command.HSTRLEN = utils.convReturnVertxGen(Command, JCommand.HSTRLEN);
Command.HVALS = utils.convReturnVertxGen(Command, JCommand.HVALS);
Command.INCR = utils.convReturnVertxGen(Command, JCommand.INCR);
Command.INCRBY = utils.convReturnVertxGen(Command, JCommand.INCRBY);
Command.INCRBYFLOAT = utils.convReturnVertxGen(Command, JCommand.INCRBYFLOAT);
Command.INFO = utils.convReturnVertxGen(Command, JCommand.INFO);
Command.KEYS = utils.convReturnVertxGen(Command, JCommand.KEYS);
Command.LASTSAVE = utils.convReturnVertxGen(Command, JCommand.LASTSAVE);
Command.LATENCY = utils.convReturnVertxGen(Command, JCommand.LATENCY);
Command.LINDEX = utils.convReturnVertxGen(Command, JCommand.LINDEX);
Command.LINSERT = utils.convReturnVertxGen(Command, JCommand.LINSERT);
Command.LLEN = utils.convReturnVertxGen(Command, JCommand.LLEN);
Command.LOLWUT = utils.convReturnVertxGen(Command, JCommand.LOLWUT);
Command.LPOP = utils.convReturnVertxGen(Command, JCommand.LPOP);
Command.LPUSH = utils.convReturnVertxGen(Command, JCommand.LPUSH);
Command.LPUSHX = utils.convReturnVertxGen(Command, JCommand.LPUSHX);
Command.LRANGE = utils.convReturnVertxGen(Command, JCommand.LRANGE);
Command.LREM = utils.convReturnVertxGen(Command, JCommand.LREM);
Command.LSET = utils.convReturnVertxGen(Command, JCommand.LSET);
Command.LTRIM = utils.convReturnVertxGen(Command, JCommand.LTRIM);
Command.MEMORY = utils.convReturnVertxGen(Command, JCommand.MEMORY);
Command.MGET = utils.convReturnVertxGen(Command, JCommand.MGET);
Command.MIGRATE = utils.convReturnVertxGen(Command, JCommand.MIGRATE);
Command.MODULE = utils.convReturnVertxGen(Command, JCommand.MODULE);
Command.MONITOR = utils.convReturnVertxGen(Command, JCommand.MONITOR);
Command.MOVE = utils.convReturnVertxGen(Command, JCommand.MOVE);
Command.MSET = utils.convReturnVertxGen(Command, JCommand.MSET);
Command.MSETNX = utils.convReturnVertxGen(Command, JCommand.MSETNX);
Command.MULTI = utils.convReturnVertxGen(Command, JCommand.MULTI);
Command.OBJECT = utils.convReturnVertxGen(Command, JCommand.OBJECT);
Command.PERSIST = utils.convReturnVertxGen(Command, JCommand.PERSIST);
Command.PEXPIRE = utils.convReturnVertxGen(Command, JCommand.PEXPIRE);
Command.PEXPIREAT = utils.convReturnVertxGen(Command, JCommand.PEXPIREAT);
Command.PFADD = utils.convReturnVertxGen(Command, JCommand.PFADD);
Command.PFCOUNT = utils.convReturnVertxGen(Command, JCommand.PFCOUNT);
Command.PFDEBUG = utils.convReturnVertxGen(Command, JCommand.PFDEBUG);
Command.PFMERGE = utils.convReturnVertxGen(Command, JCommand.PFMERGE);
Command.PFSELFTEST = utils.convReturnVertxGen(Command, JCommand.PFSELFTEST);
Command.PING = utils.convReturnVertxGen(Command, JCommand.PING);
Command.POST = utils.convReturnVertxGen(Command, JCommand.POST);
Command.PSETEX = utils.convReturnVertxGen(Command, JCommand.PSETEX);
Command.PSUBSCRIBE = utils.convReturnVertxGen(Command, JCommand.PSUBSCRIBE);
Command.PSYNC = utils.convReturnVertxGen(Command, JCommand.PSYNC);
Command.PTTL = utils.convReturnVertxGen(Command, JCommand.PTTL);
Command.PUBLISH = utils.convReturnVertxGen(Command, JCommand.PUBLISH);
Command.PUBSUB = utils.convReturnVertxGen(Command, JCommand.PUBSUB);
Command.PUNSUBSCRIBE = utils.convReturnVertxGen(Command, JCommand.PUNSUBSCRIBE);
Command.RANDOMKEY = utils.convReturnVertxGen(Command, JCommand.RANDOMKEY);
Command.READONLY = utils.convReturnVertxGen(Command, JCommand.READONLY);
Command.READWRITE = utils.convReturnVertxGen(Command, JCommand.READWRITE);
Command.RENAME = utils.convReturnVertxGen(Command, JCommand.RENAME);
Command.RENAMENX = utils.convReturnVertxGen(Command, JCommand.RENAMENX);
Command.REPLCONF = utils.convReturnVertxGen(Command, JCommand.REPLCONF);
Command.REPLICAOF = utils.convReturnVertxGen(Command, JCommand.REPLICAOF);
Command.RESTORE = utils.convReturnVertxGen(Command, JCommand.RESTORE);
Command.RESTORE_ASKING = utils.convReturnVertxGen(Command, JCommand.RESTORE_ASKING);
Command.ROLE = utils.convReturnVertxGen(Command, JCommand.ROLE);
Command.RPOP = utils.convReturnVertxGen(Command, JCommand.RPOP);
Command.RPOPLPUSH = utils.convReturnVertxGen(Command, JCommand.RPOPLPUSH);
Command.RPUSH = utils.convReturnVertxGen(Command, JCommand.RPUSH);
Command.RPUSHX = utils.convReturnVertxGen(Command, JCommand.RPUSHX);
Command.SADD = utils.convReturnVertxGen(Command, JCommand.SADD);
Command.SAVE = utils.convReturnVertxGen(Command, JCommand.SAVE);
Command.SCAN = utils.convReturnVertxGen(Command, JCommand.SCAN);
Command.SCARD = utils.convReturnVertxGen(Command, JCommand.SCARD);
Command.SCRIPT = utils.convReturnVertxGen(Command, JCommand.SCRIPT);
Command.SDIFF = utils.convReturnVertxGen(Command, JCommand.SDIFF);
Command.SDIFFSTORE = utils.convReturnVertxGen(Command, JCommand.SDIFFSTORE);
Command.SELECT = utils.convReturnVertxGen(Command, JCommand.SELECT);
Command.SET = utils.convReturnVertxGen(Command, JCommand.SET);
Command.SETBIT = utils.convReturnVertxGen(Command, JCommand.SETBIT);
Command.SETEX = utils.convReturnVertxGen(Command, JCommand.SETEX);
Command.SETNX = utils.convReturnVertxGen(Command, JCommand.SETNX);
Command.SETRANGE = utils.convReturnVertxGen(Command, JCommand.SETRANGE);
Command.SHUTDOWN = utils.convReturnVertxGen(Command, JCommand.SHUTDOWN);
Command.SINTER = utils.convReturnVertxGen(Command, JCommand.SINTER);
Command.SINTERSTORE = utils.convReturnVertxGen(Command, JCommand.SINTERSTORE);
Command.SISMEMBER = utils.convReturnVertxGen(Command, JCommand.SISMEMBER);
Command.SLAVEOF = utils.convReturnVertxGen(Command, JCommand.SLAVEOF);
Command.SLOWLOG = utils.convReturnVertxGen(Command, JCommand.SLOWLOG);
Command.SMEMBERS = utils.convReturnVertxGen(Command, JCommand.SMEMBERS);
Command.SMOVE = utils.convReturnVertxGen(Command, JCommand.SMOVE);
Command.SORT = utils.convReturnVertxGen(Command, JCommand.SORT);
Command.SPOP = utils.convReturnVertxGen(Command, JCommand.SPOP);
Command.SRANDMEMBER = utils.convReturnVertxGen(Command, JCommand.SRANDMEMBER);
Command.SREM = utils.convReturnVertxGen(Command, JCommand.SREM);
Command.SSCAN = utils.convReturnVertxGen(Command, JCommand.SSCAN);
Command.STRLEN = utils.convReturnVertxGen(Command, JCommand.STRLEN);
Command.SUBSCRIBE = utils.convReturnVertxGen(Command, JCommand.SUBSCRIBE);
Command.SUBSTR = utils.convReturnVertxGen(Command, JCommand.SUBSTR);
Command.SUNION = utils.convReturnVertxGen(Command, JCommand.SUNION);
Command.SUNIONSTORE = utils.convReturnVertxGen(Command, JCommand.SUNIONSTORE);
Command.SWAPDB = utils.convReturnVertxGen(Command, JCommand.SWAPDB);
Command.SYNC = utils.convReturnVertxGen(Command, JCommand.SYNC);
Command.TIME = utils.convReturnVertxGen(Command, JCommand.TIME);
Command.TOUCH = utils.convReturnVertxGen(Command, JCommand.TOUCH);
Command.TTL = utils.convReturnVertxGen(Command, JCommand.TTL);
Command.TYPE = utils.convReturnVertxGen(Command, JCommand.TYPE);
Command.UNLINK = utils.convReturnVertxGen(Command, JCommand.UNLINK);
Command.UNSUBSCRIBE = utils.convReturnVertxGen(Command, JCommand.UNSUBSCRIBE);
Command.UNWATCH = utils.convReturnVertxGen(Command, JCommand.UNWATCH);
Command.WAIT = utils.convReturnVertxGen(Command, JCommand.WAIT);
Command.WATCH = utils.convReturnVertxGen(Command, JCommand.WATCH);
Command.XACK = utils.convReturnVertxGen(Command, JCommand.XACK);
Command.XADD = utils.convReturnVertxGen(Command, JCommand.XADD);
Command.XCLAIM = utils.convReturnVertxGen(Command, JCommand.XCLAIM);
Command.XDEL = utils.convReturnVertxGen(Command, JCommand.XDEL);
Command.XGROUP = utils.convReturnVertxGen(Command, JCommand.XGROUP);
Command.XINFO = utils.convReturnVertxGen(Command, JCommand.XINFO);
Command.XLEN = utils.convReturnVertxGen(Command, JCommand.XLEN);
Command.XPENDING = utils.convReturnVertxGen(Command, JCommand.XPENDING);
Command.XRANGE = utils.convReturnVertxGen(Command, JCommand.XRANGE);
Command.XREAD = utils.convReturnVertxGen(Command, JCommand.XREAD);
Command.XREADGROUP = utils.convReturnVertxGen(Command, JCommand.XREADGROUP);
Command.XREVRANGE = utils.convReturnVertxGen(Command, JCommand.XREVRANGE);
Command.XSETID = utils.convReturnVertxGen(Command, JCommand.XSETID);
Command.XTRIM = utils.convReturnVertxGen(Command, JCommand.XTRIM);
Command.ZADD = utils.convReturnVertxGen(Command, JCommand.ZADD);
Command.ZCARD = utils.convReturnVertxGen(Command, JCommand.ZCARD);
Command.ZCOUNT = utils.convReturnVertxGen(Command, JCommand.ZCOUNT);
Command.ZINCRBY = utils.convReturnVertxGen(Command, JCommand.ZINCRBY);
Command.ZINTERSTORE = utils.convReturnVertxGen(Command, JCommand.ZINTERSTORE);
Command.ZLEXCOUNT = utils.convReturnVertxGen(Command, JCommand.ZLEXCOUNT);
Command.ZPOPMAX = utils.convReturnVertxGen(Command, JCommand.ZPOPMAX);
Command.ZPOPMIN = utils.convReturnVertxGen(Command, JCommand.ZPOPMIN);
Command.ZRANGE = utils.convReturnVertxGen(Command, JCommand.ZRANGE);
Command.ZRANGEBYLEX = utils.convReturnVertxGen(Command, JCommand.ZRANGEBYLEX);
Command.ZRANGEBYSCORE = utils.convReturnVertxGen(Command, JCommand.ZRANGEBYSCORE);
Command.ZRANK = utils.convReturnVertxGen(Command, JCommand.ZRANK);
Command.ZREM = utils.convReturnVertxGen(Command, JCommand.ZREM);
Command.ZREMRANGEBYLEX = utils.convReturnVertxGen(Command, JCommand.ZREMRANGEBYLEX);
Command.ZREMRANGEBYRANK = utils.convReturnVertxGen(Command, JCommand.ZREMRANGEBYRANK);
Command.ZREMRANGEBYSCORE = utils.convReturnVertxGen(Command, JCommand.ZREMRANGEBYSCORE);
Command.ZREVRANGE = utils.convReturnVertxGen(Command, JCommand.ZREVRANGE);
Command.ZREVRANGEBYLEX = utils.convReturnVertxGen(Command, JCommand.ZREVRANGEBYLEX);
Command.ZREVRANGEBYSCORE = utils.convReturnVertxGen(Command, JCommand.ZREVRANGEBYSCORE);
Command.ZREVRANK = utils.convReturnVertxGen(Command, JCommand.ZREVRANK);
Command.ZSCAN = utils.convReturnVertxGen(Command, JCommand.ZSCAN);
Command.ZSCORE = utils.convReturnVertxGen(Command, JCommand.ZSCORE);
Command.ZUNIONSTORE = utils.convReturnVertxGen(Command, JCommand.ZUNIONSTORE);
Command.SENTINEL = utils.convReturnVertxGen(Command, JCommand.SENTINEL);
module.exports = Command;