/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-shell-js/command_process */
var utils = require('vertx-js/util/utils');
var CommandLine = require('vertx-js/command_line');
var Vertx = require('vertx-js/vertx');
var CliToken = require('vertx-shell-js/cli_token');
var Tty = require('vertx-shell-js/tty');
var Session = require('vertx-shell-js/session');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JCommandProcess = Java.type('io.vertx.ext.shell.command.CommandProcess');

/**
 The command process provides interaction with the process of the command provided by Vert.x Shell.

 @class
*/
var CommandProcess = function(j_val) {

  var j_commandProcess = j_val;
  var that = this;
  Tty.call(this, j_val);

  var __super_vertx = this.vertx;
  var __super_argsTokens = this.argsTokens;
  var __super_args = this.args;
  var __super_commandLine = this.commandLine;
  var __super_session = this.session;
  var __super_isForeground = this.isForeground;
  var __super_stdinHandler = this.stdinHandler;
  var __super_interruptHandler = this.interruptHandler;
  var __super_suspendHandler = this.suspendHandler;
  var __super_resumeHandler = this.resumeHandler;
  var __super_endHandler = this.endHandler;
  var __super_write = this.write;
  var __super_backgroundHandler = this.backgroundHandler;
  var __super_foregroundHandler = this.foregroundHandler;
  var __super_resizehandler = this.resizehandler;
  var __super_end = this.end;
  var __super_end = this.end;
  /**

   @public

   @return {Vertx} the current Vert.x instance
   */
  this.vertx =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Vertx, j_commandProcess["vertx()"]()) ;
    } else if (typeof __super_vertx != 'undefined') {
      return __super_vertx.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<CliToken>} the unparsed arguments tokens
   */
  this.argsTokens =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetVertxGen(j_commandProcess["argsTokens()"](), CliToken) ;
    } else if (typeof __super_argsTokens != 'undefined') {
      return __super_argsTokens.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<string>} the actual string arguments of the command
   */
  this.args =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_commandProcess["args()"]() ;
    } else if (typeof __super_args != 'undefined') {
      return __super_args.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {CommandLine} the command line object or null
   */
  this.commandLine =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(CommandLine, j_commandProcess["commandLine()"]()) ;
    } else if (typeof __super_commandLine != 'undefined') {
      return __super_commandLine.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Session} the shell session
   */
  this.session =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Session, j_commandProcess["session()"]()) ;
    } else if (typeof __super_session != 'undefined') {
      return __super_session.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} true if the command is running in foreground
   */
  this.isForeground =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_commandProcess["isForeground()"]() ;
    } else if (typeof __super_isForeground != 'undefined') {
      return __super_isForeground.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {CommandProcess}
   */
  this.stdinHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_commandProcess["stdinHandler(io.vertx.core.Handler)"](function(jVal) {
        handler(jVal);
      }) ;
      return that;
    } else if (typeof __super_stdinHandler != 'undefined') {
      return __super_stdinHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an interrupt handler, this handler is called when the command is interrupted, for instance user
   press <code>Ctrl-C</code>.

   @public
   @param handler {function} the interrupt handler 
   @return {CommandProcess} this command
   */
  this.interruptHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_commandProcess["interruptHandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_interruptHandler != 'undefined') {
      return __super_interruptHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set a suspend handler, this handler is called when the command is suspended, for instance user
   press <code>Ctrl-Z</code>.

   @public
   @param handler {function} the interrupt handler 
   @return {CommandProcess} this command
   */
  this.suspendHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_commandProcess["suspendHandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_suspendHandler != 'undefined') {
      return __super_suspendHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set a resume handler, this handler is called when the command is resumed, for instance user
   types <code>bg</code> or <code>fg</code> to resume the command.

   @public
   @param handler {function} the interrupt handler 
   @return {CommandProcess} this command
   */
  this.resumeHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_commandProcess["resumeHandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_resumeHandler != 'undefined') {
      return __super_resumeHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an end handler, this handler is called when the command is ended, for instance the command is running
   and the shell closes.

   @public
   @param handler {function} the end handler 
   @return {CommandProcess} a reference to this, so the API can be used fluently
   */
  this.endHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_commandProcess["endHandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_endHandler != 'undefined') {
      return __super_endHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Write some text to the standard output.

   @public
   @param data {string} the text 
   @return {CommandProcess} a reference to this, so the API can be used fluently
   */
  this.write =  function(data) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_commandProcess["write(java.lang.String)"](data) ;
      return that;
    } else if (typeof __super_write != 'undefined') {
      return __super_write.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set a background handler, this handler is called when the command is running and put to background.

   @public
   @param handler {function} the background handler 
   @return {CommandProcess} this command
   */
  this.backgroundHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_commandProcess["backgroundHandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_backgroundHandler != 'undefined') {
      return __super_backgroundHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set a foreground handler, this handler is called when the command is running and put to foreground.

   @public
   @param handler {function} the foreground handler 
   @return {CommandProcess} this command
   */
  this.foregroundHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_commandProcess["foregroundHandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_foregroundHandler != 'undefined') {
      return __super_foregroundHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {CommandProcess}
   */
  this.resizehandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_commandProcess["resizehandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_resizehandler != 'undefined') {
      return __super_resizehandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   End the process.

   @public
   @param status {number} the exit status. 
   */
  this.end =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_commandProcess["end()"]();
    } else if (__args.length === 1 && typeof __args[0] ==='number') {
      j_commandProcess["end(int)"](__args[0]);
    } else if (typeof __super_end != 'undefined') {
      return __super_end.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_commandProcess;
};

CommandProcess._jclass = utils.getJavaClass("io.vertx.ext.shell.command.CommandProcess");
CommandProcess._jtype = {accept: function(obj) {
    return CommandProcess._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(CommandProcess.prototype, {});
    CommandProcess.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
CommandProcess._create = function(jdel) {var obj = Object.create(CommandProcess.prototype, {});
  CommandProcess.apply(obj, arguments);
  return obj;
}
module.exports = CommandProcess;