/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-amqp-client-js/amqp_client */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');
var AmqpSender = require('vertx-amqp-client-js/amqp_sender');
var AmqpConnection = require('vertx-amqp-client-js/amqp_connection');
var AmqpReceiver = require('vertx-amqp-client-js/amqp_receiver');
var Future = require('vertx-js/future');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAmqpClient = Java.type('io.vertx.amqp.AmqpClient');
var AmqpClientOptions = Java.type('io.vertx.amqp.AmqpClientOptions');
var AmqpSenderOptions = Java.type('io.vertx.amqp.AmqpSenderOptions');
var AmqpReceiverOptions = Java.type('io.vertx.amqp.AmqpReceiverOptions');

/**
 AMQP Client entry point.
 @class
*/
var AmqpClient = function(j_val) {

  var j_amqpClient = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_connect = this.connect;
  var __super_close = this.close;
  var __super_createReceiver = this.createReceiver;
  var __super_createReceiver = this.createReceiver;
  var __super_createSender = this.createSender;
  var __super_createSender = this.createSender;
  /**
   Connects to the AMQP broker or router. The location is specified in the <a href="../../dataobjects.html#AmqpClientOptions">AmqpClientOptions</a> as well as the
   potential credential required.

   @public
   @param connectionHandler {function} handler that will process the result, giving either the connection or failure cause. Must not be <code>null</code>. 
   @return {AmqpClient}
   */
  this.connect =  function(connectionHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_amqpClient["connect(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          connectionHandler(utils.convReturnVertxGen(AmqpConnection, ar.result()), null);
        } else {
          connectionHandler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpClient["connect(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpConnection, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_connect != 'undefined') {
      return __super_connect.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Closes the client.
   The client must always be closed once not needed anymore.

   @public
   @param closeHandler {function} the close handler notified when the operation completes. It can be <code>null</code>. 
   */
  this.close =  function(closeHandler) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'function' || __args[0] == null)) {
      j_amqpClient["close(io.vertx.core.Handler)"](closeHandler == null ? null : function(ar) {
        if (ar.succeeded()) {
          closeHandler(null, null);
        } else {
          closeHandler(null, ar.cause());
        }
      });
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpClient["close(io.vertx.core.Handler)"](__prom_completer_handler == null ? null : function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   explicitly. You can retrieve the connection using {@link AmqpReceiver#connection}.

   @public
   @param address {string} The source address to attach the consumer to. 
   @param receiverOptions {Object} The options for this receiver. 
   @param completionHandler {function} The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery. 
   @return {AmqpClient} the connection.
   */
  this.createReceiver =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_amqpClient["createReceiver(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpClient["createReceiver(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_amqpClient["createReceiver(java.lang.String,io.vertx.amqp.AmqpReceiverOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new AmqpReceiverOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null)) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpClient["createReceiver(java.lang.String,io.vertx.amqp.AmqpReceiverOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new AmqpReceiverOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpReceiver, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_createReceiver != 'undefined') {
      return __super_createReceiver.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Creates a sender used to send messages to the given address. The address must be set.

   @public
   @param address {string} The target address to attach to, must not be <code>null</code> 
   @param options {Object} The options for this sender. 
   @param completionHandler {function} The handler called with the sender, once opened 
   @return {AmqpClient} the client.
   */
  this.createSender =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_amqpClient["createSender(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(AmqpSender, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpClient["createSender(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpSender, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_amqpClient["createSender(java.lang.String,io.vertx.amqp.AmqpSenderOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new AmqpSenderOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(AmqpSender, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null)) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_amqpClient["createSender(java.lang.String,io.vertx.amqp.AmqpSenderOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new AmqpSenderOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(AmqpSender, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_createSender != 'undefined') {
      return __super_createSender.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_amqpClient;
};

AmqpClient._jclass = utils.getJavaClass("io.vertx.amqp.AmqpClient");
AmqpClient._jtype = {accept: function(obj) {
    return AmqpClient._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(AmqpClient.prototype, {});
    AmqpClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
AmqpClient._create = function(jdel) {var obj = Object.create(AmqpClient.prototype, {});
  AmqpClient.apply(obj, arguments);
  return obj;
}
/**
 Creates a new instance of {@link AmqpClient} with the given Vert.x instance and the given options.

 @memberof module:vertx-amqp-client-js/amqp_client
 @param vertx {Vertx} the vert.x instance, must not be <code>null</code> 
 @param options {Object} the AMQP options, may be @{code null} falling back to the default configuration 
 @return {AmqpClient} the AMQP client instance
 */
AmqpClient.create =  function() {
  var __args = arguments;
  if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
    return utils.convReturnVertxGen(AmqpClient, JAmqpClient["create(io.vertx.amqp.AmqpClientOptions)"](__args[0]  != null ? new AmqpClientOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(AmqpClient, JAmqpClient["create(io.vertx.core.Vertx,io.vertx.amqp.AmqpClientOptions)"](__args[0]._jdel, __args[1]  != null ? new AmqpClientOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = AmqpClient;
var Promise = require('vertx-js/promise');
