/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-common-js/and_authorization */
var utils = require('vertx-js/util/utils');
var Authorization = require('vertx-auth-common-js/authorization');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAndAuthorization = Java.type('io.vertx.ext.auth.authorization.AndAuthorization');

/**
 Allows to perform a logical 'and' between several authorizations

 @class
*/
var AndAuthorization = function(j_val) {

  var j_andAuthorization = j_val;
  var that = this;
  Authorization.call(this, j_val);

  var __super_create = this.create;
  var __super_getAuthorizations = this.getAuthorizations;
  var __super_addAuthorization = this.addAuthorization;
  /**

   @public

   @return {Array.<Authorization>}
   */
  this.getAuthorizations =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetVertxGen(j_andAuthorization["getAuthorizations()"](), Authorization) ;
    } else if (typeof __super_getAuthorizations != 'undefined') {
      return __super_getAuthorizations.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param authorization {Authorization} 
   @return {AndAuthorization}
   */
  this.addAuthorization =  function(authorization) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnVertxGen(AndAuthorization, j_andAuthorization["addAuthorization(io.vertx.ext.auth.authorization.Authorization)"](authorization._jdel)) ;
    } else if (typeof __super_addAuthorization != 'undefined') {
      return __super_addAuthorization.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_andAuthorization;
};

AndAuthorization._jclass = utils.getJavaClass("io.vertx.ext.auth.authorization.AndAuthorization");
AndAuthorization._jtype = {accept: function(obj) {
    return AndAuthorization._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(AndAuthorization.prototype, {});
    AndAuthorization.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
AndAuthorization._create = function(jdel) {var obj = Object.create(AndAuthorization.prototype, {});
  AndAuthorization.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-auth-common-js/and_authorization

 @return {AndAuthorization}
 */
AndAuthorization.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(AndAuthorization, JAndAuthorization["create()"]()) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = AndAuthorization;
var Promise = require('vertx-js/promise');
