/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-common-js/auth_provider */
var utils = require('vertx-js/util/utils');
var AuthenticationProvider = require('vertx-auth-common-js/authentication_provider');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAuthProvider = Java.type('io.vertx.ext.auth.AuthProvider');

/**

 User-facing interface for authenticating users.

 @class
*/
var AuthProvider = function(j_val) {

  var j_authProvider = j_val;
  var that = this;
  AuthenticationProvider.call(this, j_val);

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_authProvider;
};

AuthProvider._jclass = utils.getJavaClass("io.vertx.ext.auth.AuthProvider");
AuthProvider._jtype = {accept: function(obj) {
    return AuthProvider._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(AuthProvider.prototype, {});
    AuthProvider.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
AuthProvider._create = function(jdel) {var obj = Object.create(AuthProvider.prototype, {});
  AuthProvider.apply(obj, arguments);
  return obj;
}
module.exports = AuthProvider;
var Promise = require('vertx-js/promise');
