/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-common-js/authorization */
var utils = require('vertx-js/util/utils');
var AuthorizationContext = require('vertx-auth-common-js/authorization_context');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAuthorization = Java.type('io.vertx.ext.auth.authorization.Authorization');

/**
 Interface representing any kind of authorization such as:
 <ul>
   <li>Role based authorization
   <li>Permission based authorization
   <li>Logical authorization (AND, OR, NOT)
   <li>Time based authorization (ie: allow access the last 5 days of the month, from 8am till 10am, etc.)
   <li>Context based authorization (ie: allow access if the ip address is 'xxx.xxx.xxx.xxx')
   <li>Custom based authorization (ie: based on a script or hard-coded code specific to an application)
   <li>etc.
 </ul>
 The following implementations are provided out of the box:
 <ul>
 @class
*/
var Authorization = function(j_val) {

  var j_authorization = j_val;
  var that = this;

  var __super_match = this.match;
  var __super_verify = this.verify;
  /**
   this methods verifies whether or not the authorization match the specified
   context.

   @public
   @param context {AuthorizationContext} 
   @return {boolean} 
   */
  this.match =  function(context) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return j_authorization["match(io.vertx.ext.auth.authorization.AuthorizationContext)"](context._jdel) ;
    } else if (typeof __super_match != 'undefined') {
      return __super_match.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   this method verifies whether or not the authorization implies the specified
   authorization.
   </br>Note that it doesn't always mean an exact match. For instance,
   in the case of a {@link WildcardPermissionBasedAuthorization}, this method
   may return true even if the permissions are different
   </br>WildcardPermissionBasedAuthorization.create('*').implies(WildcardPermissionBasedAuthorization.create('anypermission'))
   would return true

   @public
   @param authorization {Authorization} 
   @return {boolean} 
   */
  this.verify =  function(authorization) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return j_authorization["verify(io.vertx.ext.auth.authorization.Authorization)"](authorization._jdel) ;
    } else if (typeof __super_verify != 'undefined') {
      return __super_verify.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_authorization;
};

Authorization._jclass = utils.getJavaClass("io.vertx.ext.auth.authorization.Authorization");
Authorization._jtype = {accept: function(obj) {
    return Authorization._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Authorization.prototype, {});
    Authorization.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Authorization._create = function(jdel) {var obj = Object.create(Authorization.prototype, {});
  Authorization.apply(obj, arguments);
  return obj;
}
module.exports = Authorization;
var Promise = require('vertx-js/promise');
