/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-common-js/authorization_context */
var utils = require('vertx-js/util/utils');
var User = require('vertx-auth-common-js/user');
var MultiMap = require('vertx-js/multi_map');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAuthorizationContext = Java.type('io.vertx.ext.auth.authorization.AuthorizationContext');

/**
 The AuthorizationContext contains properties that can be used to match
 authorizations.

 @class
*/
var AuthorizationContext = function(j_val) {

  var j_authorizationContext = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_user = this.user;
  var __super_variables = this.variables;
  /**
   Get the authenticated user

   @public

   @return {User} the user
   */
  this.user =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(User, j_authorizationContext["user()"]()) ;
    } else if (typeof __super_user != 'undefined') {
      return __super_user.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {MultiMap} a Multimap containing variable names and values that can be resolved at runtime by {@link Authorization}Authorizations
   */
  this.variables =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(MultiMap, j_authorizationContext["variables()"]()) ;
    } else if (typeof __super_variables != 'undefined') {
      return __super_variables.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_authorizationContext;
};

AuthorizationContext._jclass = utils.getJavaClass("io.vertx.ext.auth.authorization.AuthorizationContext");
AuthorizationContext._jtype = {accept: function(obj) {
    return AuthorizationContext._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(AuthorizationContext.prototype, {});
    AuthorizationContext.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
AuthorizationContext._create = function(jdel) {var obj = Object.create(AuthorizationContext.prototype, {});
  AuthorizationContext.apply(obj, arguments);
  return obj;
}
/**
 Factory for Authorization Context

 @memberof module:vertx-auth-common-js/authorization_context
 @param user {User} a user 
 @return {AuthorizationContext} a AuthorizationContext instance
 */
AuthorizationContext.create =  function(user) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(AuthorizationContext, JAuthorizationContext["create(io.vertx.ext.auth.User)"](user._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = AuthorizationContext;
var Promise = require('vertx-js/promise');
