/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-common-js/authorization_provider */
var utils = require('vertx-js/util/utils');
var User = require('vertx-auth-common-js/user');
var Authorization = require('vertx-auth-common-js/authorization');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAuthorizationProvider = Java.type('io.vertx.ext.auth.authorization.AuthorizationProvider');

/**
 The role of an AuthorizationProvider is to return a set of Authorization.
 Note that each AuthorizationProvider must provide its own unique Id

 @class
*/
var AuthorizationProvider = function(j_val) {

  var j_authorizationProvider = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_getId = this.getId;
  var __super_getAuthorizations = this.getAuthorizations;
  /**
   returns the id of the authorization provider

   @public

   @return {string} 
   */
  this.getId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_authorizationProvider["getId()"]() ;
    } else if (typeof __super_getId != 'undefined') {
      return __super_getId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the set of authorizations of the specified user

   @public
   @param user {User} 
   @param handler {function} 
   */
  this.getAuthorizations =  function(user, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'function') {
      j_authorizationProvider["getAuthorizations(io.vertx.ext.auth.User,io.vertx.core.Handler)"](user._jdel, function(ar) {
        if (ar.succeeded()) {
          handler(utils.convReturnListSetVertxGen(ar.result(), Authorization), null);
        } else {
          handler(null, ar.cause());
        }
      });
    } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_authorizationProvider["getAuthorizations(io.vertx.ext.auth.User,io.vertx.core.Handler)"](user._jdel, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnListSetVertxGen(ar.result(), Authorization), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_getAuthorizations != 'undefined') {
      return __super_getAuthorizations.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_authorizationProvider;
};

AuthorizationProvider._jclass = utils.getJavaClass("io.vertx.ext.auth.authorization.AuthorizationProvider");
AuthorizationProvider._jtype = {accept: function(obj) {
    return AuthorizationProvider._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(AuthorizationProvider.prototype, {});
    AuthorizationProvider.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
AuthorizationProvider._create = function(jdel) {var obj = Object.create(AuthorizationProvider.prototype, {});
  AuthorizationProvider.apply(obj, arguments);
  return obj;
}
/**
 create an authorization provider with the specified id and authorizations

 @memberof module:vertx-auth-common-js/authorization_provider
 @param id {string} 
 @param authorizations {Array.<Authorization>} 
 @return {AuthorizationProvider} 
 */
AuthorizationProvider.create =  function(id, authorizations) {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array) {
    return utils.convReturnVertxGen(AuthorizationProvider, JAuthorizationProvider["create(java.lang.String,java.util.Set)"](id, utils.convParamSetVertxGen(authorizations))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = AuthorizationProvider;
var Promise = require('vertx-js/promise');
