/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-common-js/authorizations */
var utils = require('vertx-js/util/utils');
var Authorization = require('vertx-auth-common-js/authorization');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAuthorizations = Java.type('io.vertx.ext.auth.authorization.Authorizations');

/**
 @class
*/
var Authorizations = function(j_val) {

  var j_authorizations = j_val;
  var that = this;

  var __super_add = this.add;
  var __super_add = this.add;
  var __super_delete = this.delete;
  var __super_get = this.get;
  var __super_getProviderIds = this.getProviderIds;
  /**

   @public
   @param providerId {string} 
   @param authorization {Authorization} 
   @return {Authorizations}
   */
  this.add =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array) {
      j_authorizations["add(java.lang.String,java.util.Set)"](__args[0], utils.convParamSetVertxGen(__args[1])) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel) {
      j_authorizations["add(java.lang.String,io.vertx.ext.auth.authorization.Authorization)"](__args[0], __args[1]._jdel) ;
      return that;
    } else if (typeof __super_add != 'undefined') {
      return __super_add.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param providerId {string} 
   @return {Authorizations}
   */
  this.delete =  function(providerId) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_authorizations["delete(java.lang.String)"](providerId) ;
      return that;
    } else if (typeof __super_delete != 'undefined') {
      return __super_delete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param providerId {string} 
   @return {Array.<Authorization>}
   */
  this.get =  function(providerId) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnListSetVertxGen(j_authorizations["get(java.lang.String)"](providerId), Authorization) ;
    } else if (typeof __super_get != 'undefined') {
      return __super_get.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<string>}
   */
  this.getProviderIds =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_authorizations["getProviderIds()"]()) ;
    } else if (typeof __super_getProviderIds != 'undefined') {
      return __super_getProviderIds.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_authorizations;
};

Authorizations._jclass = utils.getJavaClass("io.vertx.ext.auth.authorization.Authorizations");
Authorizations._jtype = {accept: function(obj) {
    return Authorizations._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Authorizations.prototype, {});
    Authorizations.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Authorizations._create = function(jdel) {var obj = Object.create(Authorizations.prototype, {});
  Authorizations.apply(obj, arguments);
  return obj;
}
module.exports = Authorizations;
var Promise = require('vertx-js/promise');
