/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-common-js/not_authorization */
var utils = require('vertx-js/util/utils');
var Authorization = require('vertx-auth-common-js/authorization');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JNotAuthorization = Java.type('io.vertx.ext.auth.authorization.NotAuthorization');

/**
 Allows to perform a logical 'not' of the specified authorization

 @class
*/
var NotAuthorization = function(j_val) {

  var j_notAuthorization = j_val;
  var that = this;
  Authorization.call(this, j_val);

  var __super_create = this.create;
  var __super_getAuthorization = this.getAuthorization;
  /**

   @public

   @return {Authorization}
   */
  this.getAuthorization =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Authorization, j_notAuthorization["getAuthorization()"]()) ;
    } else if (typeof __super_getAuthorization != 'undefined') {
      return __super_getAuthorization.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_notAuthorization;
};

NotAuthorization._jclass = utils.getJavaClass("io.vertx.ext.auth.authorization.NotAuthorization");
NotAuthorization._jtype = {accept: function(obj) {
    return NotAuthorization._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(NotAuthorization.prototype, {});
    NotAuthorization.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
NotAuthorization._create = function(jdel) {var obj = Object.create(NotAuthorization.prototype, {});
  NotAuthorization.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-auth-common-js/not_authorization
 @param authorization {Authorization} 
 @return {NotAuthorization}
 */
NotAuthorization.create =  function(authorization) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(NotAuthorization, JNotAuthorization["create(io.vertx.ext.auth.authorization.Authorization)"](authorization._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = NotAuthorization;
var Promise = require('vertx-js/promise');
