/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-common-js/wildcard_permission_based_authorization */
var utils = require('vertx-js/util/utils');
var Authorization = require('vertx-auth-common-js/authorization');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JWildcardPermissionBasedAuthorization = Java.type('io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization');

/**
 Represents a wildcard permission (ie: 'manage:order:*' '*:orders', '*', etc.)
 Note that it can optionally be assigned to a specific resource

 @class
*/
var WildcardPermissionBasedAuthorization = function(j_val) {

  var j_wildcardPermissionBasedAuthorization = j_val;
  var that = this;
  Authorization.call(this, j_val);

  var __super_create = this.create;
  var __super_getPermission = this.getPermission;
  var __super_getResource = this.getResource;
  var __super_setResource = this.setResource;
  /**
   return the value of the wildcard permission

   @public

   @return {string} 
   */
  this.getPermission =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_wildcardPermissionBasedAuthorization["getPermission()"]() ;
    } else if (typeof __super_getPermission != 'undefined') {
      return __super_getPermission.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   returns an optional resource that the permission is assigned-on

   @public

   @return {string} 
   */
  this.getResource =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_wildcardPermissionBasedAuthorization["getResource()"]() ;
    } else if (typeof __super_getResource != 'undefined') {
      return __super_getResource.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   sets an optional resource that the permission is assigned-on

   @public
   @param resource {string} 
   @return {WildcardPermissionBasedAuthorization} 
   */
  this.setResource =  function(resource) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_wildcardPermissionBasedAuthorization["setResource(java.lang.String)"](resource) ;
      return that;
    } else if (typeof __super_setResource != 'undefined') {
      return __super_setResource.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_wildcardPermissionBasedAuthorization;
};

WildcardPermissionBasedAuthorization._jclass = utils.getJavaClass("io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization");
WildcardPermissionBasedAuthorization._jtype = {accept: function(obj) {
    return WildcardPermissionBasedAuthorization._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(WildcardPermissionBasedAuthorization.prototype, {});
    WildcardPermissionBasedAuthorization.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
WildcardPermissionBasedAuthorization._create = function(jdel) {var obj = Object.create(WildcardPermissionBasedAuthorization.prototype, {});
  WildcardPermissionBasedAuthorization.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-auth-common-js/wildcard_permission_based_authorization
 @param permission {string} 
 @return {WildcardPermissionBasedAuthorization}
 */
WildcardPermissionBasedAuthorization.create =  function(permission) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'string') {
    return utils.convReturnVertxGen(WildcardPermissionBasedAuthorization, JWildcardPermissionBasedAuthorization["create(java.lang.String)"](permission)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = WildcardPermissionBasedAuthorization;
var Promise = require('vertx-js/promise');
