/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-htpasswd-js/htpasswd_auth */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');
var AuthenticationProvider = require('vertx-auth-common-js/authentication_provider');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JHtpasswdAuth = Java.type('io.vertx.ext.auth.htpasswd.HtpasswdAuth');
var HtpasswdAuthOptions = Java.type('io.vertx.ext.auth.htpasswd.HtpasswdAuthOptions');

/**
 An extension of AuthProvider which is using htpasswd file as store

 @class
*/
var HtpasswdAuth = function(j_val) {

  var j_htpasswdAuth = j_val;
  var that = this;
  AuthenticationProvider.call(this, j_val);

  var __super_create = this.create;
  var __super_create = this.create;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_htpasswdAuth;
};

HtpasswdAuth._jclass = utils.getJavaClass("io.vertx.ext.auth.htpasswd.HtpasswdAuth");
HtpasswdAuth._jtype = {accept: function(obj) {
    return HtpasswdAuth._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(HtpasswdAuth.prototype, {});
    HtpasswdAuth.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
HtpasswdAuth._create = function(jdel) {var obj = Object.create(HtpasswdAuth.prototype, {});
  HtpasswdAuth.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-auth-htpasswd-js/htpasswd_auth
 @param vertx {Vertx} 
 @param htpasswdAuthOptions {Object} 
 @return {HtpasswdAuth}
 */
HtpasswdAuth.create =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(HtpasswdAuth, JHtpasswdAuth["create(io.vertx.core.Vertx)"](__args[0]._jdel)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(HtpasswdAuth, JHtpasswdAuth["create(io.vertx.core.Vertx,io.vertx.ext.auth.htpasswd.HtpasswdAuthOptions)"](__args[0]._jdel, __args[1]  != null ? new HtpasswdAuthOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = HtpasswdAuth;
var Promise = require('vertx-js/promise');
