/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-jdbc-js/jdbc_authentication */
var utils = require('vertx-js/util/utils');
var JDBCClient = require('vertx-jdbc-js/jdbc_client');
var JDBCHashStrategy = require('vertx-auth-jdbc-js/jdbc_hash_strategy');
var AuthProvider = require('vertx-auth-common-js/auth_provider');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JJDBCAuthentication = Java.type('io.vertx.ext.auth.jdbc.JDBCAuthentication');
var JDBCAuthenticationOptions = Java.type('io.vertx.ext.auth.jdbc.JDBCAuthenticationOptions');

/**

 @class
*/
var JDBCAuthentication = function(j_val) {

  var j_jDBCAuthentication = j_val;
  var that = this;
  AuthProvider.call(this, j_val);

  var __super_create = this.create;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_jDBCAuthentication;
};

JDBCAuthentication._jclass = utils.getJavaClass("io.vertx.ext.auth.jdbc.JDBCAuthentication");
JDBCAuthentication._jtype = {accept: function(obj) {
    return JDBCAuthentication._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(JDBCAuthentication.prototype, {});
    JDBCAuthentication.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
JDBCAuthentication._create = function(jdel) {var obj = Object.create(JDBCAuthentication.prototype, {});
  JDBCAuthentication.apply(obj, arguments);
  return obj;
}
/**
 Create a JDBC auth provider implementation

 @memberof module:vertx-auth-jdbc-js/jdbc_authentication
 @param client {JDBCClient} the JDBC client instance 
 @param hashStrategy {JDBCHashStrategy} 
 @param options {Object} authentication options 
 @return {JDBCAuthentication} the auth provider
 */
JDBCAuthentication.create =  function(client, hashStrategy, options) {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && (typeof __args[2] === 'object' && __args[2] != null)) {
    return utils.convReturnVertxGen(JDBCAuthentication, JJDBCAuthentication["create(io.vertx.ext.jdbc.JDBCClient,io.vertx.ext.auth.jdbc.JDBCHashStrategy,io.vertx.ext.auth.jdbc.JDBCAuthenticationOptions)"](client._jdel, hashStrategy._jdel, options  != null ? new JDBCAuthenticationOptions(new JsonObject(Java.asJSONCompatible(options))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = JDBCAuthentication;
var Promise = require('vertx-js/promise');
