/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-jdbc-js/jdbc_authorization */
var utils = require('vertx-js/util/utils');
var JDBCClient = require('vertx-jdbc-js/jdbc_client');
var AuthorizationProvider = require('vertx-auth-common-js/authorization_provider');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JJDBCAuthorization = Java.type('io.vertx.ext.auth.jdbc.JDBCAuthorization');
var JDBCAuthorizationOptions = Java.type('io.vertx.ext.auth.jdbc.JDBCAuthorizationOptions');

/**

 @class
*/
var JDBCAuthorization = function(j_val) {

  var j_jDBCAuthorization = j_val;
  var that = this;
  AuthorizationProvider.call(this, j_val);

  var __super_create = this.create;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_jDBCAuthorization;
};

JDBCAuthorization._jclass = utils.getJavaClass("io.vertx.ext.auth.jdbc.JDBCAuthorization");
JDBCAuthorization._jtype = {accept: function(obj) {
    return JDBCAuthorization._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(JDBCAuthorization.prototype, {});
    JDBCAuthorization.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
JDBCAuthorization._create = function(jdel) {var obj = Object.create(JDBCAuthorization.prototype, {});
  JDBCAuthorization.apply(obj, arguments);
  return obj;
}
/**
 Create a JDBC authorization provider implementation

 @memberof module:vertx-auth-jdbc-js/jdbc_authorization
 @param providerId {string} the provider id 
 @param client {JDBCClient} the JDBC client instance 
 @param options {Object} the <a href="../../dataobjects.html#JDBCAuthorizationOptions">JDBCAuthorizationOptions</a> 
 @return {JDBCAuthorization} the auth provider
 */
JDBCAuthorization.create =  function(providerId, client, options) {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && (typeof __args[2] === 'object' && __args[2] != null)) {
    return utils.convReturnVertxGen(JDBCAuthorization, JJDBCAuthorization["create(java.lang.String,io.vertx.ext.jdbc.JDBCClient,io.vertx.ext.auth.jdbc.JDBCAuthorizationOptions)"](providerId, client._jdel, options  != null ? new JDBCAuthorizationOptions(new JsonObject(Java.asJSONCompatible(options))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = JDBCAuthorization;
var Promise = require('vertx-js/promise');
