/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-jwt-js/jwt_authorization */
var utils = require('vertx-js/util/utils');
var AuthorizationProvider = require('vertx-auth-common-js/authorization_provider');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JJWTAuthorization = Java.type('io.vertx.ext.auth.jwt.authorization.JWTAuthorization');

/**
 Implementation of the JWT authorization provider.

 @class
*/
var JWTAuthorization = function(j_val) {

  var j_jWTAuthorization = j_val;
  var that = this;
  AuthorizationProvider.call(this, j_val);

  var __super_create = this.create;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_jWTAuthorization;
};

JWTAuthorization._jclass = utils.getJavaClass("io.vertx.ext.auth.jwt.authorization.JWTAuthorization");
JWTAuthorization._jtype = {accept: function(obj) {
    return JWTAuthorization._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(JWTAuthorization.prototype, {});
    JWTAuthorization.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
JWTAuthorization._create = function(jdel) {var obj = Object.create(JWTAuthorization.prototype, {});
  JWTAuthorization.apply(obj, arguments);
  return obj;
}
/**
 Factory method to create a Authorization provider for JWT tokens.

 @memberof module:vertx-auth-jwt-js/jwt_authorization
 @param rootClaim {string} slash separated string to the json array with the claims. 
 @return {JWTAuthorization} a AuthorizationProvider
 */
JWTAuthorization.create =  function(rootClaim) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'string') {
    return utils.convReturnVertxGen(JWTAuthorization, JJWTAuthorization["create(java.lang.String)"](rootClaim)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = JWTAuthorization;
var Promise = require('vertx-js/promise');
