/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-jwt-js/micro_profile_authorization */
var utils = require('vertx-js/util/utils');
var AuthorizationProvider = require('vertx-auth-common-js/authorization_provider');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JMicroProfileAuthorization = Java.type('io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization');

/**
 Implementation of the Microprofile MP-JWT 1.1 RBAC based on the access token groups key.

 @class
*/
var MicroProfileAuthorization = function(j_val) {

  var j_microProfileAuthorization = j_val;
  var that = this;
  AuthorizationProvider.call(this, j_val);

  var __super_create = this.create;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_microProfileAuthorization;
};

MicroProfileAuthorization._jclass = utils.getJavaClass("io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization");
MicroProfileAuthorization._jtype = {accept: function(obj) {
    return MicroProfileAuthorization._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(MicroProfileAuthorization.prototype, {});
    MicroProfileAuthorization.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MicroProfileAuthorization._create = function(jdel) {var obj = Object.create(MicroProfileAuthorization.prototype, {});
  MicroProfileAuthorization.apply(obj, arguments);
  return obj;
}
/**
 Factory method to create a Authorization provider for tokens adhering to the MP-JWT 1.1 spec.
 When the user is known to not be a JWT, (e.g.: a OAuth2 response token) then the root claim
 is expected to be extracted from  under the key <code>accessToken</code>.

 @memberof module:vertx-auth-jwt-js/micro_profile_authorization

 @return {MicroProfileAuthorization} a AuthorizationProvider
 */
MicroProfileAuthorization.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(MicroProfileAuthorization, JMicroProfileAuthorization["create()"]()) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = MicroProfileAuthorization;
var Promise = require('vertx-js/promise');
