/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-oauth2-js/keycloak_authorization */
var utils = require('vertx-js/util/utils');
var AuthorizationProvider = require('vertx-auth-common-js/authorization_provider');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JKeycloakAuthorization = Java.type('io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization');

/**
 Implementation of the Keycloak Authorization Provider.

 @class
*/
var KeycloakAuthorization = function(j_val) {

  var j_keycloakAuthorization = j_val;
  var that = this;
  AuthorizationProvider.call(this, j_val);

  var __super_create = this.create;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_keycloakAuthorization;
};

KeycloakAuthorization._jclass = utils.getJavaClass("io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization");
KeycloakAuthorization._jtype = {accept: function(obj) {
    return KeycloakAuthorization._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(KeycloakAuthorization.prototype, {});
    KeycloakAuthorization.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
KeycloakAuthorization._create = function(jdel) {var obj = Object.create(KeycloakAuthorization.prototype, {});
  KeycloakAuthorization.apply(obj, arguments);
  return obj;
}
/**
 Factory method to create an Authorization Provider for tokens adhering to the Keycloak token format.
 When the user is known to not be a JWT, (e.g.: a OAuth2 response token) then the root claim
 is expected to be the extracted from the user  under the key: <code>accessToken</code>.

 @memberof module:vertx-auth-oauth2-js/keycloak_authorization

 @return {KeycloakAuthorization} a AuthorizationProvider
 */
KeycloakAuthorization.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(KeycloakAuthorization, JKeycloakAuthorization["create()"]()) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = KeycloakAuthorization;
var Promise = require('vertx-js/promise');
