/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-oauth2-js/o_auth2_rbac */
var utils = require('vertx-js/util/utils');
var AccessToken = require('vertx-auth-oauth2-js/access_token');
var Future = require('vertx-js/future');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JOAuth2RBAC = Java.type('io.vertx.ext.auth.oauth2.OAuth2RBAC');

/**
 Functional interface that allows users to implement custom RBAC verifiers for OAuth2/OpenId Connect.

 Users are to implement the <code>isAuthorized</code> method to verify authorities. For provides that do not
 export the permissions/roles in the token, this interface allows you to communicate with 3rd party services
 such as graph APIs to collect the required data.

 The contract is that once an authority is checked for a given user, it's value is cached during the execution
 of the request. If a user is stored to a persistent storage, or the token is introspected, the cache is cleared
 and a new call will be handled to the implementation.

 @class
*/
var OAuth2RBAC = function(j_val) {

  var j_oAuth2RBAC = j_val;
  var that = this;

  var __super_isAuthorized = this.isAuthorized;
  /**
   This method should verify if the user has the given authority and return either a boolean value or an error.

   Note that false and errors are not the same. A user might not have a given authority but that doesn't mean that
   there was an error during the call.

   @public
   @param user {AccessToken} the given user to assert on 
   @param authority {string} the authority to lookup 
   @param handler {function} the result handler. 
   */
  this.isAuthorized =  function(user, authority, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_oAuth2RBAC["isAuthorized(io.vertx.ext.auth.oauth2.AccessToken,java.lang.String,io.vertx.core.Handler)"](user._jdel, authority, function(ar) {
        if (ar.succeeded()) {
          handler(ar.result(), null);
        } else {
          handler(null, ar.cause());
        }
      });
    } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_oAuth2RBAC["isAuthorized(io.vertx.ext.auth.oauth2.AccessToken,java.lang.String,io.vertx.core.Handler)"](user._jdel, authority, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(ar.result(), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_isAuthorized != 'undefined') {
      return __super_isAuthorized.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_oAuth2RBAC;
};

OAuth2RBAC._jclass = utils.getJavaClass("io.vertx.ext.auth.oauth2.OAuth2RBAC");
OAuth2RBAC._jtype = {accept: function(obj) {
    return OAuth2RBAC._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(OAuth2RBAC.prototype, {});
    OAuth2RBAC.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
OAuth2RBAC._create = function(jdel) {var obj = Object.create(OAuth2RBAC.prototype, {});
  OAuth2RBAC.apply(obj, arguments);
  return obj;
}
module.exports = OAuth2RBAC;
var Promise = require('vertx-js/promise');
