/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-oauth2-js/open_id_connect_auth */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');
var OAuth2Auth = require('vertx-auth-oauth2-js/o_auth2_auth');
var Future = require('vertx-js/future');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JOpenIDConnectAuth = Java.type('io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth');
var OAuth2ClientOptions = Java.type('io.vertx.ext.auth.oauth2.OAuth2ClientOptions');

/**

 @class
*/
var OpenIDConnectAuth = function(j_val) {

  var j_openIDConnectAuth = j_val;
  var that = this;

  var __super_discover = this.discover;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_openIDConnectAuth;
};

OpenIDConnectAuth._jclass = utils.getJavaClass("io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth");
OpenIDConnectAuth._jtype = {accept: function(obj) {
    return OpenIDConnectAuth._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(OpenIDConnectAuth.prototype, {});
    OpenIDConnectAuth.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
OpenIDConnectAuth._create = function(jdel) {var obj = Object.create(OpenIDConnectAuth.prototype, {});
  OpenIDConnectAuth.apply(obj, arguments);
  return obj;
}
/**
 Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the given site in the
 configuration options and attempt to load the well known descriptor.
 <p>
 If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
 into the OAuth provider so tokens can be decoded.

 @memberof module:vertx-auth-oauth2-js/open_id_connect_auth
 @param vertx {Vertx} the vertx instance 
 @param config {Object} the initial config, it should contain a site url 
 @param handler {function} the instantiated Oauth2 provider instance handler 
 */
OpenIDConnectAuth.discover =  function(vertx, config, handler) {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
    JOpenIDConnectAuth["discover(io.vertx.core.Vertx,io.vertx.ext.auth.oauth2.OAuth2ClientOptions,io.vertx.core.Handler)"](vertx._jdel, config  != null ? new OAuth2ClientOptions(new JsonObject(Java.asJSONCompatible(config))) : null, function(ar) {
      if (ar.succeeded()) {
        handler(utils.convReturnVertxGen(OAuth2Auth, ar.result()), null);
      } else {
        handler(null, ar.cause());
      }
    });
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    var __prom = Promise.promise();
    var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
    JOpenIDConnectAuth["discover(io.vertx.core.Vertx,io.vertx.ext.auth.oauth2.OAuth2ClientOptions,io.vertx.core.Handler)"](vertx._jdel, config  != null ? new OAuth2ClientOptions(new JsonObject(Java.asJSONCompatible(config))) : null, function(ar) {
      if (ar.succeeded()) {
        __prom_completer_handler(utils.convReturnVertxGen(OAuth2Auth, ar.result()), null);
      } else {
        __prom_completer_handler(null, ar.cause());
      }
    });
    return __prom.future();
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = OpenIDConnectAuth;
var Promise = require('vertx-js/promise');
