/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-bridge-common-js/base_bridge_event */
var utils = require('vertx-js/util/utils');
var Promise = require('vertx-js/promise');
var Future = require('vertx-js/future');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JBaseBridgeEvent = Java.type('io.vertx.ext.bridge.BaseBridgeEvent');

/**
 Represents an event that occurs on the event bus bridge.
 <p>
 Please consult the documentation for a full explanation.

 @class
*/
var BaseBridgeEvent = function(j_val) {

  var j_baseBridgeEvent = j_val;
  var that = this;
  Promise.call(this, j_val, undefined);

  var __super_complete = this.complete;
  var __super_tryComplete = this.tryComplete;
  var __super_future = this.future;
  var __super_type = this.type;
  var __super_getRawMessage = this.getRawMessage;
  var __super_setRawMessage = this.setRawMessage;
  /**
   Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
   <p/>
   Any handler set on the associated promise will be called.

   @public
   @param result {boolean} the result 
   */
  this.complete =  function(result) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_baseBridgeEvent["complete(java.lang.Boolean)"](result);
    } else if (typeof __super_complete != 'undefined') {
      return __super_complete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Like {@link Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
   an IllegalStateException, it returns <code>true</code> otherwise.

   @public
   @param result {boolean} the result 
   @return {boolean} <code>false</code> when the future is already completed
   */
  this.tryComplete =  function(result) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_baseBridgeEvent["tryComplete(java.lang.Boolean)"](result) ;
    } else if (typeof __super_tryComplete != 'undefined') {
      return __super_tryComplete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Future} the  associated with this promise, it can be used to be aware of the promise completion
   */
  this.future =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedfuture == null) {
        that.cachedfuture = utils.convReturnVertxGen(Future, j_baseBridgeEvent["future()"](), undefined);
      }
      return that.cachedfuture;
    } else if (typeof __super_future != 'undefined') {
      return __super_future.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object} the type of the event
   */
  this.type =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedtype == null) {
        that.cachedtype = utils.convReturnEnum(j_baseBridgeEvent["type()"]());
      }
      return that.cachedtype;
    } else if (typeof __super_type != 'undefined') {
      return __super_type.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
   no message involved. If the returned message is modified, {@link BaseBridgeEvent#setRawMessage} should be called with the
   new message.

   @public

   @return {Object} the raw JSON message for the event
   */
  this.getRawMessage =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_baseBridgeEvent["getRawMessage()"]()) ;
    } else if (typeof __super_getRawMessage != 'undefined') {
      return __super_getRawMessage.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
   no message involved.

   @public
   @param message {Object} the raw message 
   @return {BaseBridgeEvent} this reference, so it can be used fluently
   */
  this.setRawMessage =  function(message) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_baseBridgeEvent["setRawMessage(io.vertx.core.json.JsonObject)"](utils.convParamJsonObject(message)) ;
      return that;
    } else if (typeof __super_setRawMessage != 'undefined') {
      return __super_setRawMessage.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_baseBridgeEvent;
};

BaseBridgeEvent._jclass = utils.getJavaClass("io.vertx.ext.bridge.BaseBridgeEvent");
BaseBridgeEvent._jtype = {accept: function(obj) {
    return BaseBridgeEvent._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(BaseBridgeEvent.prototype, {});
    BaseBridgeEvent.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
BaseBridgeEvent._create = function(jdel) {var obj = Object.create(BaseBridgeEvent.prototype, {});
  BaseBridgeEvent.apply(obj, arguments);
  return obj;
}
module.exports = BaseBridgeEvent;
var Promise = require('vertx-js/promise');
