/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-mysql-client-js/my_sql_client */
var utils = require('vertx-js/util/utils');
var PropertyKind = require('vertx-sql-client-js/property_kind');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JMySQLClient = Java.type('io.vertx.mysqlclient.MySQLClient');

/**
 An interface to define MySQL specific constants or behaviors.

 @class
*/
var MySQLClient = function(j_val) {

  var j_mySQLClient = j_val;
  var that = this;

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_mySQLClient;
};

MySQLClient._jclass = utils.getJavaClass("io.vertx.mysqlclient.MySQLClient");
MySQLClient._jtype = {accept: function(obj) {
    return MySQLClient._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(MySQLClient.prototype, {});
    MySQLClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MySQLClient._create = function(jdel) {var obj = Object.create(MySQLClient.prototype, {});
  MySQLClient.apply(obj, arguments);
  return obj;
}
MySQLClient.LAST_INSERTED_ID = utils.convReturnVertxGen(PropertyKind, JMySQLClient.LAST_INSERTED_ID, undefined);
module.exports = MySQLClient;
var Promise = require('vertx-js/promise');
