/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-mysql-client-js/my_sql_connection */
var utils = require('vertx-js/util/utils');
var SqlConnection = require('vertx-sql-client-js/sql_connection');
var Vertx = require('vertx-js/vertx');
var Row = require('vertx-sql-client-js/row');
var RowSet = require('vertx-sql-client-js/row_set');
var Future = require('vertx-js/future');
var PreparedQuery = require('vertx-sql-client-js/prepared_query');
var Tuple = require('vertx-sql-client-js/tuple');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JMySQLConnection = Java.type('io.vertx.mysqlclient.MySQLConnection');
var MySQLAuthOptions = Java.type('io.vertx.mysqlclient.MySQLAuthOptions');
var MySQLConnectOptions = Java.type('io.vertx.mysqlclient.MySQLConnectOptions');

/**
 A connection to MySQL server.

 @class
*/
var MySQLConnection = function(j_val) {

  var j_mySQLConnection = j_val;
  var that = this;
  SqlConnection.call(this, j_val);

  var __super_connect = this.connect;
  var __super_connect = this.connect;
  var __super_prepare = this.prepare;
  var __super_exceptionHandler = this.exceptionHandler;
  var __super_closeHandler = this.closeHandler;
  var __super_preparedQuery = this.preparedQuery;
  var __super_query = this.query;
  var __super_preparedQuery = this.preparedQuery;
  var __super_ping = this.ping;
  var __super_specifySchema = this.specifySchema;
  var __super_getInternalStatistics = this.getInternalStatistics;
  var __super_setOption = this.setOption;
  var __super_resetConnection = this.resetConnection;
  var __super_debug = this.debug;
  var __super_changeUser = this.changeUser;
  /**

   @public
   @param sql {string} 
   @param handler {function} 
   @return {MySQLConnection}
   */
  this.prepare =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mySQLConnection["prepare(java.lang.String,io.vertx.core.Handler)"](sql, function(ar) {
        if (ar.succeeded()) {
          handler(utils.convReturnVertxGen(PreparedQuery, ar.result()), null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["prepare(java.lang.String,io.vertx.core.Handler)"](sql, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(PreparedQuery, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_prepare != 'undefined') {
      return __super_prepare.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {MySQLConnection}
   */
  this.exceptionHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_mySQLConnection["exceptionHandler(io.vertx.core.Handler)"](function(jVal) {
        handler(utils.convReturnThrowable(jVal));
      }) ;
      return that;
    } else if (typeof __super_exceptionHandler != 'undefined') {
      return __super_exceptionHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {MySQLConnection}
   */
  this.closeHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_mySQLConnection["closeHandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_closeHandler != 'undefined') {
      return __super_closeHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param arguments {Tuple} 
   @param handler {function} 
   @return {MySQLConnection}
   */
  this.preparedQuery =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mySQLConnection["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'function') {
      j_mySQLConnection["preparedQuery(java.lang.String,io.vertx.sqlclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["preparedQuery(java.lang.String,io.vertx.sqlclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_preparedQuery != 'undefined') {
      return __super_preparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param handler {function} 
   @return {MySQLConnection}
   */
  this.query =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mySQLConnection["query(java.lang.String,io.vertx.core.Handler)"](sql, function(ar) {
        if (ar.succeeded()) {
          handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["query(java.lang.String,io.vertx.core.Handler)"](sql, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a PING command to check if the server is alive.

   @public
   @param handler {function} the handler notified when the server responses to client 
   @return {MySQLConnection} a reference to this, so the API can be used fluently
   */
  this.ping =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_mySQLConnection["ping(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["ping(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_ping != 'undefined') {
      return __super_ping.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a INIT_DB command to change the default schema of the connection.

   @public
   @param schemaName {string} name of the schema to change to 
   @param handler {function} the handler notified with the execution result 
   @return {MySQLConnection} a reference to this, so the API can be used fluently
   */
  this.specifySchema =  function(schemaName, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mySQLConnection["specifySchema(java.lang.String,io.vertx.core.Handler)"](schemaName, function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["specifySchema(java.lang.String,io.vertx.core.Handler)"](schemaName, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_specifySchema != 'undefined') {
      return __super_specifySchema.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a STATISTICS command to get a human readable string of the server internal status.

   @public
   @param handler {function} the handler notified with the execution result 
   @return {MySQLConnection} a reference to this, so the API can be used fluently
   */
  this.getInternalStatistics =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_mySQLConnection["getInternalStatistics(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          handler(ar.result(), null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["getInternalStatistics(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(ar.result(), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_getInternalStatistics != 'undefined') {
      return __super_getInternalStatistics.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a SET_OPTION command to set options for the current connection.

   @public
   @param option {Object} the options to set 
   @param handler {function} the handler notified with the execution result 
   @return {MySQLConnection} a reference to this, so the API can be used fluently
   */
  this.setOption =  function(option, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mySQLConnection["setOption(io.vertx.mysqlclient.MySQLSetOption,io.vertx.core.Handler)"](io.vertx.mysqlclient.MySQLSetOption.valueOf(option), function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["setOption(io.vertx.mysqlclient.MySQLSetOption,io.vertx.core.Handler)"](io.vertx.mysqlclient.MySQLSetOption.valueOf(option), function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_setOption != 'undefined') {
      return __super_setOption.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a RESET_CONNECTION command to reset the session state.

   @public
   @param handler {function} the handler notified with the execution result 
   @return {MySQLConnection} a reference to this, so the API can be used fluently
   */
  this.resetConnection =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_mySQLConnection["resetConnection(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["resetConnection(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_resetConnection != 'undefined') {
      return __super_resetConnection.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a DEBUG command to dump debug information to the server's stdout.

   @public
   @param handler {function} the handler notified with the execution result 
   @return {MySQLConnection} a reference to this, so the API can be used fluently
   */
  this.debug =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_mySQLConnection["debug(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["debug(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_debug != 'undefined') {
      return __super_debug.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.

   @public
   @param options {Object} authentication options 
   @param handler {function} the handler 
   @return {MySQLConnection} a reference to this, so the API can be used fluently
   */
  this.changeUser =  function(options, handler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_mySQLConnection["changeUser(io.vertx.mysqlclient.MySQLAuthOptions,io.vertx.core.Handler)"](options  != null ? new MySQLAuthOptions(new JsonObject(Java.asJSONCompatible(options))) : null, function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mySQLConnection["changeUser(io.vertx.mysqlclient.MySQLAuthOptions,io.vertx.core.Handler)"](options  != null ? new MySQLAuthOptions(new JsonObject(Java.asJSONCompatible(options))) : null, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_changeUser != 'undefined') {
      return __super_changeUser.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_mySQLConnection;
};

MySQLConnection._jclass = utils.getJavaClass("io.vertx.mysqlclient.MySQLConnection");
MySQLConnection._jtype = {accept: function(obj) {
    return MySQLConnection._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(MySQLConnection.prototype, {});
    MySQLConnection.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MySQLConnection._create = function(jdel) {var obj = Object.create(MySQLConnection.prototype, {});
  MySQLConnection.apply(obj, arguments);
  return obj;
}
/**
 Like {@link MySQLConnection#connect} with options build from <code>connectionUri</code>.

 @memberof module:vertx-mysql-client-js/my_sql_connection
 @param vertx {Vertx} 
 @param connectionUri {string} 
 @param handler {function} 
 */
MySQLConnection.connect =  function() {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
    JMySQLConnection["connect(io.vertx.core.Vertx,io.vertx.mysqlclient.MySQLConnectOptions,io.vertx.core.Handler)"](__args[0]._jdel, __args[1]  != null ? new MySQLConnectOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
      if (ar.succeeded()) {
        __args[2](utils.convReturnVertxGen(MySQLConnection, ar.result()), null);
      } else {
        __args[2](null, ar.cause());
      }
    });
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    var __prom = Promise.promise();
    var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
    JMySQLConnection["connect(io.vertx.core.Vertx,io.vertx.mysqlclient.MySQLConnectOptions,io.vertx.core.Handler)"](__args[0]._jdel, __args[1]  != null ? new MySQLConnectOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
      if (ar.succeeded()) {
        __prom_completer_handler(utils.convReturnVertxGen(MySQLConnection, ar.result()), null);
      } else {
        __prom_completer_handler(null, ar.cause());
      }
    });
    return __prom.future();
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
    JMySQLConnection["connect(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](__args[0]._jdel, __args[1], function(ar) {
      if (ar.succeeded()) {
        __args[2](utils.convReturnVertxGen(MySQLConnection, ar.result()), null);
      } else {
        __args[2](null, ar.cause());
      }
    });
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string') {
    var __prom = Promise.promise();
    var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
    JMySQLConnection["connect(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](__args[0]._jdel, __args[1], function(ar) {
      if (ar.succeeded()) {
        __prom_completer_handler(utils.convReturnVertxGen(MySQLConnection, ar.result()), null);
      } else {
        __prom_completer_handler(null, ar.cause());
      }
    });
    return __prom.future();
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = MySQLConnection;
var Promise = require('vertx-js/promise');
