/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-shell-js/command_registry */
var utils = require('vertx-js/util/utils');
var Command = require('vertx-shell-js/command');
var Vertx = require('vertx-js/vertx');
var CommandResolver = require('vertx-shell-js/command_resolver');
var Future = require('vertx-js/future');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JCommandRegistry = Java.type('io.vertx.ext.shell.command.CommandRegistry');

/**
 A registry that contains the commands known by a shell.<p/>

 It is a mutable command resolver.


 @class
*/
var CommandRegistry = function(j_val) {

  var j_commandRegistry = j_val;
  var that = this;
  CommandResolver.call(this, j_val);

  var __super_getShared = this.getShared;
  var __super_create = this.create;
  var __super_registerCommand = this.registerCommand;
  var __super_registerCommands = this.registerCommands;
  var __super_unregisterCommand = this.unregisterCommand;
  /**
   Register a command

   @public
   @param command {Command} the command to register 
   @param completionHandler {function} notified when the command is registered 
   @return {CommandRegistry} a reference to this, so the API can be used fluently
   */
  this.registerCommand =  function(command, completionHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'function') {
      j_commandRegistry["registerCommand(io.vertx.ext.shell.command.Command,io.vertx.core.Handler)"](command._jdel, function(ar) {
        if (ar.succeeded()) {
          completionHandler(utils.convReturnVertxGen(Command, ar.result()), null);
        } else {
          completionHandler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_commandRegistry["registerCommand(io.vertx.ext.shell.command.Command,io.vertx.core.Handler)"](command._jdel, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(Command, ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_registerCommand != 'undefined') {
      return __super_registerCommand.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Register a list of commands.

   @public
   @param commands {Array.<Command>} the commands to register 
   @param completionHandler {function} notified when the command is registered 
   @return {CommandRegistry} a reference to this, so the API can be used fluently
   */
  this.registerCommands =  function(commands, completionHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_commandRegistry["registerCommands(java.util.List,io.vertx.core.Handler)"](utils.convParamListVertxGen(commands), function(ar) {
        if (ar.succeeded()) {
          completionHandler(utils.convReturnListSetVertxGen(ar.result(), Command), null);
        } else {
          completionHandler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_commandRegistry["registerCommands(java.util.List,io.vertx.core.Handler)"](utils.convParamListVertxGen(commands), function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnListSetVertxGen(ar.result(), Command), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_registerCommands != 'undefined') {
      return __super_registerCommands.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Unregister a command.

   @public
   @param commandName {string} the command name 
   @param completionHandler {function} notified when the command is unregistered 
   @return {CommandRegistry} a reference to this, so the API can be used fluently
   */
  this.unregisterCommand =  function(commandName, completionHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_commandRegistry["unregisterCommand(java.lang.String,io.vertx.core.Handler)"](commandName, function(ar) {
        if (ar.succeeded()) {
          completionHandler(null, null);
        } else {
          completionHandler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_commandRegistry["unregisterCommand(java.lang.String,io.vertx.core.Handler)"](commandName, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_unregisterCommand != 'undefined') {
      return __super_unregisterCommand.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_commandRegistry;
};

CommandRegistry._jclass = utils.getJavaClass("io.vertx.ext.shell.command.CommandRegistry");
CommandRegistry._jtype = {accept: function(obj) {
    return CommandRegistry._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(CommandRegistry.prototype, {});
    CommandRegistry.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
CommandRegistry._create = function(jdel) {var obj = Object.create(CommandRegistry.prototype, {});
  CommandRegistry.apply(obj, arguments);
  return obj;
}
/**
 Get the shared registry for the Vert.x instance.

 @memberof module:vertx-shell-js/command_registry
 @param vertx {Vertx} the vertx instance 
 @return {CommandRegistry} the shared registry
 */
CommandRegistry.getShared =  function(vertx) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(CommandRegistry, JCommandRegistry["getShared(io.vertx.core.Vertx)"](vertx._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Create a new registry.

 @memberof module:vertx-shell-js/command_registry
 @param vertx {Vertx} the vertx instance 
 @return {CommandRegistry} the created registry
 */
CommandRegistry.create =  function(vertx) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(CommandRegistry, JCommandRegistry["create(io.vertx.core.Vertx)"](vertx._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = CommandRegistry;
var Promise = require('vertx-js/promise');
