/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-shell-js/shell_server */
var utils = require('vertx-js/util/utils');
var TermServer = require('vertx-shell-js/term_server');
var Vertx = require('vertx-js/vertx');
var Shell = require('vertx-shell-js/shell');
var CommandResolver = require('vertx-shell-js/command_resolver');
var Future = require('vertx-js/future');
var Term = require('vertx-shell-js/term');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JShellServer = Java.type('io.vertx.ext.shell.ShellServer');
var ShellServerOptions = Java.type('io.vertx.ext.shell.ShellServerOptions');

/**
 The shell server.<p/>

 @class
*/
var ShellServer = function(j_val) {

  var j_shellServer = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_registerCommandResolver = this.registerCommandResolver;
  var __super_registerTermServer = this.registerTermServer;
  var __super_createShell = this.createShell;
  var __super_createShell = this.createShell;
  var __super_listen = this.listen;
  var __super_close = this.close;
  var __super_shellHandler = this.shellHandler;
  /**
   Register a command resolver for this server.

   @public
   @param resolver {CommandResolver} the resolver 
   @return {ShellServer} a reference to this, so the API can be used fluently
   */
  this.registerCommandResolver =  function(resolver) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_shellServer["registerCommandResolver(io.vertx.ext.shell.command.CommandResolver)"](resolver._jdel) ;
      return that;
    } else if (typeof __super_registerCommandResolver != 'undefined') {
      return __super_registerCommandResolver.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Register a term server to this shell server, the term server lifecycle methods are managed by this shell server.

   @public
   @param termServer {TermServer} the term server to add 
   @return {ShellServer} a reference to this, so the API can be used fluently
   */
  this.registerTermServer =  function(termServer) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_shellServer["registerTermServer(io.vertx.ext.shell.term.TermServer)"](termServer._jdel) ;
      return that;
    } else if (typeof __super_registerTermServer != 'undefined') {
      return __super_registerTermServer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create a new shell, the returned shell should be closed explicitely.

   @public

   @return {Shell} the created shell
   */
  this.createShell =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnVertxGen(Shell, j_shellServer["createShell(io.vertx.ext.shell.term.Term)"](__args[0]._jdel)) ;
    } else if (__args.length === 0) {
      return utils.convReturnVertxGen(Shell, j_shellServer["createShell()"]()) ;
    } else if (typeof __super_createShell != 'undefined') {
      return __super_createShell.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Start the shell service, this is an asynchronous start.

   @public
   @param listenHandler {function} handler for getting notified when service is started 
   @return {ShellServer}
   */
  this.listen =  function(listenHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_shellServer["listen(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          listenHandler(null, null);
        } else {
          listenHandler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_shellServer["listen(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_listen != 'undefined') {
      return __super_listen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Close the shell server, this is an asynchronous close.

   @public
   @param completionHandler {function} handler for getting notified when service is stopped 
   */
  this.close =  function(completionHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_shellServer["close(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          completionHandler(null, null);
        } else {
          completionHandler(null, ar.cause());
        }
      });
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_shellServer["close(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Called when a new shell is created. Can be used to prepopulate the shell session with objects
   or set the prompt.

   @public
   @param shellHandler {function} handler for getting notified when the server creates a new shell. 
   */
  this.shellHandler =  function(shellHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_shellServer["shellHandler(io.vertx.core.Handler)"](function(jVal) {
        shellHandler(utils.convReturnVertxGen(Shell, jVal));
      });
    } else if (typeof __super_shellHandler != 'undefined') {
      return __super_shellHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_shellServer;
};

ShellServer._jclass = utils.getJavaClass("io.vertx.ext.shell.ShellServer");
ShellServer._jtype = {accept: function(obj) {
    return ShellServer._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ShellServer.prototype, {});
    ShellServer.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ShellServer._create = function(jdel) {var obj = Object.create(ShellServer.prototype, {});
  ShellServer.apply(obj, arguments);
  return obj;
}
/**
 Create a new shell server with specific options.

 @memberof module:vertx-shell-js/shell_server
 @param vertx {Vertx} the vertx 
 @return {ShellServer} the created shell server
 */
ShellServer.create =  function() {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(ShellServer, JShellServer["create(io.vertx.core.Vertx,io.vertx.ext.shell.ShellServerOptions)"](__args[0]._jdel, __args[1]  != null ? new ShellServerOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(ShellServer, JShellServer["create(io.vertx.core.Vertx)"](__args[0]._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = ShellServer;
var Promise = require('vertx-js/promise');
