/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/sql_client */
var utils = require('vertx-js/util/utils');
var Row = require('vertx-sql-client-js/row');
var RowSet = require('vertx-sql-client-js/row_set');
var Future = require('vertx-js/future');
var Tuple = require('vertx-sql-client-js/tuple');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JSqlClient = Java.type('io.vertx.sqlclient.SqlClient');

/**
 Defines the client operations with a database server.

 @class
*/
var SqlClient = function(j_val) {

  var j_sqlClient = j_val;
  var that = this;

  var __super_query = this.query;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedBatch = this.preparedBatch;
  var __super_close = this.close;
  /**
   Execute a simple query.

   @public
   @param sql {string} the query SQL 
   @param handler {function} the handler notified with the execution result 
   @return {SqlClient} a reference to this, so the API can be used fluently
   */
  this.query =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_sqlClient["query(java.lang.String,io.vertx.core.Handler)"](sql, function(ar) {
        if (ar.succeeded()) {
          handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_sqlClient["query(java.lang.String,io.vertx.core.Handler)"](sql, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Prepare and execute a query.

   @public
   @param sql {string} the prepared query SQL 
   @param arguments {Tuple} the list of arguments 
   @param handler {function} the handler notified with the execution result 
   @return {SqlClient} a reference to this, so the API can be used fluently
   */
  this.preparedQuery =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_sqlClient["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_sqlClient["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'function') {
      j_sqlClient["preparedQuery(java.lang.String,io.vertx.sqlclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_sqlClient["preparedQuery(java.lang.String,io.vertx.sqlclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_preparedQuery != 'undefined') {
      return __super_preparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Prepare and execute a createBatch.

   @public
   @param sql {string} the prepared query SQL 
   @param batch {Array.<Tuple>} the batch of tuples 
   @param handler {function} the handler notified with the execution result 
   @return {SqlClient} a reference to this, so the API can be used fluently
   */
  this.preparedBatch =  function(sql, batch, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'function') {
      j_sqlClient["preparedBatch(java.lang.String,java.util.List,io.vertx.core.Handler)"](sql, utils.convParamListVertxGen(batch), function(ar) {
        if (ar.succeeded()) {
          handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_sqlClient["preparedBatch(java.lang.String,java.util.List,io.vertx.core.Handler)"](sql, utils.convParamListVertxGen(batch), function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(utils.convReturnVertxGen(RowSet, ar.result(), Row._jtype), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_preparedBatch != 'undefined') {
      return __super_preparedBatch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Close the client and release the associated resources.

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_sqlClient["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_sqlClient;
};

SqlClient._jclass = utils.getJavaClass("io.vertx.sqlclient.SqlClient");
SqlClient._jtype = {accept: function(obj) {
    return SqlClient._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(SqlClient.prototype, {});
    SqlClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
SqlClient._create = function(jdel) {var obj = Object.create(SqlClient.prototype, {});
  SqlClient.apply(obj, arguments);
  return obj;
}
module.exports = SqlClient;
var Promise = require('vertx-js/promise');
