/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-js/sql_row_stream */
var utils = require('vertx-js/util/utils');
var Pipe = require('vertx-js/pipe');
var WriteStream = require('vertx-js/write_stream');
var ReadStream = require('vertx-js/read_stream');
var Future = require('vertx-js/future');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JSQLRowStream = Java.type('io.vertx.ext.sql.SQLRowStream');

/**
 A ReadStream of Rows from the underlying RDBMS. This class follows the ReadStream semantics and will automatically
 close the underlying resources if all returned rows are returned. For cases where the results are ignored before the
 full processing of the returned rows is complete the close method **MUST** be called in order to release underlying
 resources.

 The interface is minimal in order to support all SQL clients not just JDBC.

 @class
*/
var SQLRowStream = function(j_val) {

  var j_sQLRowStream = j_val;
  var that = this;
  ReadStream.call(this, j_val);

  var __super_fetch = this.fetch;
  var __super_pipe = this.pipe;
  var __super_pipeTo = this.pipeTo;
  var __super_exceptionHandler = this.exceptionHandler;
  var __super_handler = this.handler;
  var __super_pause = this.pause;
  var __super_resume = this.resume;
  var __super_endHandler = this.endHandler;
  var __super_column = this.column;
  var __super_columns = this.columns;
  var __super_resultSetClosedHandler = this.resultSetClosedHandler;
  var __super_moreResults = this.moreResults;
  var __super_close = this.close;
  var __super_close = this.close;
  /**
   Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   be added to the current stream demand.

   @public
   @param amount {number} 
   @return {ReadStream} a reference to this, so the API can be used fluently
   */
  this.fetch =  function(amount) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_sQLRowStream["fetch(long)"](amount) ;
      return that;
    } else if (typeof __super_fetch != 'undefined') {
      return __super_fetch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Pause this stream and return a  to transfer the elements of this stream to a destination .
   <p/>
   The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.

   @public

   @return {Pipe} a pipe
   */
  this.pipe =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Pipe, j_sQLRowStream["pipe()"](), undefined) ;
    } else if (typeof __super_pipe != 'undefined') {
      return __super_pipe.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   <p>
   Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   <p>
   Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   called with the result.

   @public
   @param dst {WriteStream} the destination write stream 
   @param handler {function} 
   */
  this.pipeTo =  function(dst, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'function') {
      j_sQLRowStream["pipeTo(io.vertx.core.streams.WriteStream,io.vertx.core.Handler)"](dst._jdel, function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      });
    } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_sQLRowStream["pipeTo(io.vertx.core.streams.WriteStream,io.vertx.core.Handler)"](dst._jdel, function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_pipeTo != 'undefined') {
      return __super_pipeTo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {SQLRowStream}
   */
  this.exceptionHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'function' || __args[0] == null)) {
      j_sQLRowStream["exceptionHandler(io.vertx.core.Handler)"](handler == null ? null : function(jVal) {
        handler(utils.convReturnThrowable(jVal));
      }) ;
      return that;
    } else if (typeof __super_exceptionHandler != 'undefined') {
      return __super_exceptionHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {SQLRowStream}
   */
  this.handler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'function' || __args[0] == null)) {
      j_sQLRowStream["handler(io.vertx.core.Handler)"](handler == null ? null : function(jVal) {
        handler(utils.convReturnJson(jVal));
      }) ;
      return that;
    } else if (typeof __super_handler != 'undefined') {
      return __super_handler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {SQLRowStream}
   */
  this.pause =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_sQLRowStream["pause()"]() ;
      return that;
    } else if (typeof __super_pause != 'undefined') {
      return __super_pause.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {SQLRowStream}
   */
  this.resume =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_sQLRowStream["resume()"]() ;
      return that;
    } else if (typeof __super_resume != 'undefined') {
      return __super_resume.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param endHandler {function} 
   @return {SQLRowStream}
   */
  this.endHandler =  function(endHandler) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'function' || __args[0] == null)) {
      j_sQLRowStream["endHandler(io.vertx.core.Handler)"](endHandler) ;
      return that;
    } else if (typeof __super_endHandler != 'undefined') {
      return __super_endHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Will convert the column name to the json array index.

   @public
   @param name {string} the column name 
   @return {number} the json array index
   */
  this.column =  function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_sQLRowStream["column(java.lang.String)"](name) ;
    } else if (typeof __super_column != 'undefined') {
      return __super_column.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns all column names available in the underlying resultset. One needs to carefully use this method since in
   contrast to the singular version it does not perform case insensitive lookups or takes alias in consideration on
   the column names.

   @public

   @return {Array.<string>} the list of columns names returned by the query
   */
  this.columns =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_sQLRowStream["columns()"]() ;
    } else if (typeof __super_columns != 'undefined') {
      return __super_columns.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Event handler when a resultset is closed. This is useful to request for more results.

   @public
   @param handler {function} called when the current result set is closed 
   @return {SQLRowStream}
   */
  this.resultSetClosedHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_sQLRowStream["resultSetClosedHandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else if (typeof __super_resultSetClosedHandler != 'undefined') {
      return __super_resultSetClosedHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Request for more results if available

   @public

   */
  this.moreResults =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_sQLRowStream["moreResults()"]();
    } else if (typeof __super_moreResults != 'undefined') {
      return __super_moreResults.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Closes the stream/underlying cursor(s). The actual close happens asynchronously.

   @public
   @param handler {function} called when the stream/underlying cursor(s) is(are) closed 
   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_sQLRowStream["close()"]();
    } else if (__args.length === 1 && typeof __args[0] === 'function') {
      j_sQLRowStream["close(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (__args.length === 0) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_sQLRowStream["close(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_sQLRowStream;
};

SQLRowStream._jclass = utils.getJavaClass("io.vertx.ext.sql.SQLRowStream");
SQLRowStream._jtype = {accept: function(obj) {
    return SQLRowStream._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(SQLRowStream.prototype, {});
    SQLRowStream.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
SQLRowStream._create = function(jdel) {var obj = Object.create(SQLRowStream.prototype, {});
  SQLRowStream.apply(obj, arguments);
  return obj;
}
module.exports = SQLRowStream;
var Promise = require('vertx-js/promise');
