/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/container_deserializer */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JContainerDeserializer = Java.type('io.vertx.ext.web.api.validation.ContainerDeserializer');

/**
 Interface that define methods for deserialization of array and objects

 @class
*/
var ContainerDeserializer = function(j_val) {

  var j_containerDeserializer = j_val;
  var that = this;

  var __super_deserializeArray = this.deserializeArray;
  var __super_deserializeObject = this.deserializeObject;
  /**

   @public
   @param serialized {string} 
   @return {Array.<string>}
   */
  this.deserializeArray =  function(serialized) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_containerDeserializer["deserializeArray(java.lang.String)"](serialized) ;
    } else if (typeof __super_deserializeArray != 'undefined') {
      return __super_deserializeArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param serialized {string} 
   @return {Object.<string, string>}
   */
  this.deserializeObject =  function(serialized) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnMapUnknown(j_containerDeserializer["deserializeObject(java.lang.String)"](serialized)) ;
    } else if (typeof __super_deserializeObject != 'undefined') {
      return __super_deserializeObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_containerDeserializer;
};

ContainerDeserializer._jclass = utils.getJavaClass("io.vertx.ext.web.api.validation.ContainerDeserializer");
ContainerDeserializer._jtype = {accept: function(obj) {
    return ContainerDeserializer._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ContainerDeserializer.prototype, {});
    ContainerDeserializer.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ContainerDeserializer._create = function(jdel) {var obj = Object.create(ContainerDeserializer.prototype, {});
  ContainerDeserializer.apply(obj, arguments);
  return obj;
}
module.exports = ContainerDeserializer;
var Promise = require('vertx-js/promise');
