/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/custom_validator */
var utils = require('vertx-js/util/utils');
var RoutingContext = require('vertx-web-js/routing_context');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JCustomValidator = Java.type('io.vertx.ext.web.api.validation.CustomValidator');

/**
 This interface is used to add custom <b>synchronous</b> functions inside validation process. You can add it in
 @class
*/
var CustomValidator = function(j_val) {

  var j_customValidator = j_val;
  var that = this;

  var __super_validate = this.validate;
  /**
   This function have to be <b>synchronous</b>. It doesn't return nothing if validation succedes, otherwise it
   throws ValidationException.
   <br/>
   <b>Don't call routingContext.next() or routingContext.fail() from this function</b>

   @public
   @param routingContext {RoutingContext} the actual routing context 
   */
  this.validate =  function(routingContext) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_customValidator["validate(io.vertx.ext.web.RoutingContext)"](routingContext._jdel);
    } else if (typeof __super_validate != 'undefined') {
      return __super_validate.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_customValidator;
};

CustomValidator._jclass = utils.getJavaClass("io.vertx.ext.web.api.validation.CustomValidator");
CustomValidator._jtype = {accept: function(obj) {
    return CustomValidator._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(CustomValidator.prototype, {});
    CustomValidator.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
CustomValidator._create = function(jdel) {var obj = Object.create(CustomValidator.prototype, {});
  CustomValidator.apply(obj, arguments);
  return obj;
}
module.exports = CustomValidator;
var Promise = require('vertx-js/promise');
